/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.common.utils;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import tech.powerjob.common.exception.PowerJobException;

public class HttpUtils {
    private static final OkHttpClient client = new OkHttpClient.Builder().connectTimeout(1L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).build();
    private static final int HTTP_SUCCESS_CODE = 200;

    public static String get(String url) throws IOException {
        Request request = new Request.Builder().get().url(url).build();
        return HttpUtils.execute(request);
    }

    public static String post(String url, RequestBody requestBody) throws IOException {
        Request request = new Request.Builder().post(requestBody).url(url).build();
        return HttpUtils.execute(request);
    }

    private static String execute(Request request) throws IOException {
        Throwable throwable = null;
        try (Response response = client.newCall(request).execute();){
            int responseCode = response.code();
            if (responseCode == 200) {
                ResponseBody body = response.body();
                if (body == null) {
                    String string = null;
                    return string;
                }
                String string = body.string();
                return string;
            }
            try {
                throw new PowerJobException(String.format("http request failed,code=%d", responseCode));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

