/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.waf.model.ActivatedRule;
import software.amazon.awssdk.services.waf.model.ChangeAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WebACLUpdate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WebACLUpdate> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(WebACLUpdate.getter(WebACLUpdate::actionAsString)).setter(WebACLUpdate.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<ActivatedRule> ACTIVATED_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(WebACLUpdate.getter(WebACLUpdate::activatedRule)).setter(WebACLUpdate.setter(Builder::activatedRule)).constructor(ActivatedRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActivatedRule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, ACTIVATED_RULE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String action;
    private final ActivatedRule activatedRule;

    private WebACLUpdate(BuilderImpl builder) {
        this.action = builder.action;
        this.activatedRule = builder.activatedRule;
    }

    public ChangeAction action() {
        return ChangeAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public ActivatedRule activatedRule() {
        return this.activatedRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.activatedRule());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WebACLUpdate)) {
            return false;
        }
        WebACLUpdate other = (WebACLUpdate)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.activatedRule(), other.activatedRule());
    }

    public String toString() {
        return ToString.builder((String)"WebACLUpdate").add("Action", (Object)this.actionAsString()).add("ActivatedRule", (Object)this.activatedRule()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "ActivatedRule": {
                return Optional.ofNullable(clazz.cast(this.activatedRule()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<WebACLUpdate, T> g) {
        return obj -> g.apply((WebACLUpdate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private ActivatedRule activatedRule;

        private BuilderImpl() {
        }

        private BuilderImpl(WebACLUpdate model) {
            this.action(model.action);
            this.activatedRule(model.activatedRule);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ChangeAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final ActivatedRule.Builder getActivatedRule() {
            return this.activatedRule != null ? this.activatedRule.toBuilder() : null;
        }

        @Override
        public final Builder activatedRule(ActivatedRule activatedRule) {
            this.activatedRule = activatedRule;
            return this;
        }

        public final void setActivatedRule(ActivatedRule.BuilderImpl activatedRule) {
            this.activatedRule = activatedRule != null ? activatedRule.build() : null;
        }

        public WebACLUpdate build() {
            return new WebACLUpdate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WebACLUpdate> {
        public Builder action(String var1);

        public Builder action(ChangeAction var1);

        public Builder activatedRule(ActivatedRule var1);

        default public Builder activatedRule(Consumer<ActivatedRule.Builder> activatedRule) {
            return this.activatedRule((ActivatedRule)((ActivatedRule.Builder)ActivatedRule.builder().applyMutation(activatedRule)).build());
        }
    }
}

