/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.waf.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum MigrationErrorType {
    ENTITY_NOT_SUPPORTED("ENTITY_NOT_SUPPORTED"),
    ENTITY_NOT_FOUND("ENTITY_NOT_FOUND"),
    S3_BUCKET_NO_PERMISSION("S3_BUCKET_NO_PERMISSION"),
    S3_BUCKET_NOT_ACCESSIBLE("S3_BUCKET_NOT_ACCESSIBLE"),
    S3_BUCKET_NOT_FOUND("S3_BUCKET_NOT_FOUND"),
    S3_BUCKET_INVALID_REGION("S3_BUCKET_INVALID_REGION"),
    S3_INTERNAL_ERROR("S3_INTERNAL_ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private MigrationErrorType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MigrationErrorType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(MigrationErrorType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MigrationErrorType> knownValues() {
        return Stream.of(MigrationErrorType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

