/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.AdaptersConfig;
import software.amazon.awssdk.services.textract.model.DocumentLocation;
import software.amazon.awssdk.services.textract.model.FeatureType;
import software.amazon.awssdk.services.textract.model.FeatureTypesCopier;
import software.amazon.awssdk.services.textract.model.NotificationChannel;
import software.amazon.awssdk.services.textract.model.OutputConfig;
import software.amazon.awssdk.services.textract.model.QueriesConfig;
import software.amazon.awssdk.services.textract.model.TextractRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartDocumentAnalysisRequest
extends TextractRequest
implements ToCopyableBuilder<Builder, StartDocumentAnalysisRequest> {
    private static final SdkField<DocumentLocation> DOCUMENT_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentLocation").getter(StartDocumentAnalysisRequest.getter(StartDocumentAnalysisRequest::documentLocation)).setter(StartDocumentAnalysisRequest.setter(Builder::documentLocation)).constructor(DocumentLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentLocation").build()}).build();
    private static final SdkField<List<String>> FEATURE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FeatureTypes").getter(StartDocumentAnalysisRequest.getter(StartDocumentAnalysisRequest::featureTypesAsStrings)).setter(StartDocumentAnalysisRequest.setter(Builder::featureTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeatureTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(StartDocumentAnalysisRequest.getter(StartDocumentAnalysisRequest::clientRequestToken)).setter(StartDocumentAnalysisRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build()}).build();
    private static final SdkField<String> JOB_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobTag").getter(StartDocumentAnalysisRequest.getter(StartDocumentAnalysisRequest::jobTag)).setter(StartDocumentAnalysisRequest.setter(Builder::jobTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobTag").build()}).build();
    private static final SdkField<NotificationChannel> NOTIFICATION_CHANNEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationChannel").getter(StartDocumentAnalysisRequest.getter(StartDocumentAnalysisRequest::notificationChannel)).setter(StartDocumentAnalysisRequest.setter(Builder::notificationChannel)).constructor(NotificationChannel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationChannel").build()}).build();
    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(StartDocumentAnalysisRequest.getter(StartDocumentAnalysisRequest::outputConfig)).setter(StartDocumentAnalysisRequest.setter(Builder::outputConfig)).constructor(OutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KMSKeyId").getter(StartDocumentAnalysisRequest.getter(StartDocumentAnalysisRequest::kmsKeyId)).setter(StartDocumentAnalysisRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KMSKeyId").build()}).build();
    private static final SdkField<QueriesConfig> QUERIES_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("QueriesConfig").getter(StartDocumentAnalysisRequest.getter(StartDocumentAnalysisRequest::queriesConfig)).setter(StartDocumentAnalysisRequest.setter(Builder::queriesConfig)).constructor(QueriesConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueriesConfig").build()}).build();
    private static final SdkField<AdaptersConfig> ADAPTERS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AdaptersConfig").getter(StartDocumentAnalysisRequest.getter(StartDocumentAnalysisRequest::adaptersConfig)).setter(StartDocumentAnalysisRequest.setter(Builder::adaptersConfig)).constructor(AdaptersConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdaptersConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_LOCATION_FIELD, FEATURE_TYPES_FIELD, CLIENT_REQUEST_TOKEN_FIELD, JOB_TAG_FIELD, NOTIFICATION_CHANNEL_FIELD, OUTPUT_CONFIG_FIELD, KMS_KEY_ID_FIELD, QUERIES_CONFIG_FIELD, ADAPTERS_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartDocumentAnalysisRequest.memberNameToFieldInitializer();
    private final DocumentLocation documentLocation;
    private final List<String> featureTypes;
    private final String clientRequestToken;
    private final String jobTag;
    private final NotificationChannel notificationChannel;
    private final OutputConfig outputConfig;
    private final String kmsKeyId;
    private final QueriesConfig queriesConfig;
    private final AdaptersConfig adaptersConfig;

    private StartDocumentAnalysisRequest(BuilderImpl builder) {
        super(builder);
        this.documentLocation = builder.documentLocation;
        this.featureTypes = builder.featureTypes;
        this.clientRequestToken = builder.clientRequestToken;
        this.jobTag = builder.jobTag;
        this.notificationChannel = builder.notificationChannel;
        this.outputConfig = builder.outputConfig;
        this.kmsKeyId = builder.kmsKeyId;
        this.queriesConfig = builder.queriesConfig;
        this.adaptersConfig = builder.adaptersConfig;
    }

    public final DocumentLocation documentLocation() {
        return this.documentLocation;
    }

    public final List<FeatureType> featureTypes() {
        return FeatureTypesCopier.copyStringToEnum(this.featureTypes);
    }

    public final boolean hasFeatureTypes() {
        return this.featureTypes != null && !(this.featureTypes instanceof SdkAutoConstructList);
    }

    public final List<String> featureTypesAsStrings() {
        return this.featureTypes;
    }

    public final String clientRequestToken() {
        return this.clientRequestToken;
    }

    public final String jobTag() {
        return this.jobTag;
    }

    public final NotificationChannel notificationChannel() {
        return this.notificationChannel;
    }

    public final OutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final QueriesConfig queriesConfig() {
        return this.queriesConfig;
    }

    public final AdaptersConfig adaptersConfig() {
        return this.adaptersConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.documentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFeatureTypes() ? this.featureTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationChannel());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queriesConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.adaptersConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDocumentAnalysisRequest)) {
            return false;
        }
        StartDocumentAnalysisRequest other = (StartDocumentAnalysisRequest)((Object)obj);
        return Objects.equals(this.documentLocation(), other.documentLocation()) && this.hasFeatureTypes() == other.hasFeatureTypes() && Objects.equals(this.featureTypesAsStrings(), other.featureTypesAsStrings()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.jobTag(), other.jobTag()) && Objects.equals(this.notificationChannel(), other.notificationChannel()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.queriesConfig(), other.queriesConfig()) && Objects.equals(this.adaptersConfig(), other.adaptersConfig());
    }

    public final String toString() {
        return ToString.builder((String)"StartDocumentAnalysisRequest").add("DocumentLocation", (Object)this.documentLocation()).add("FeatureTypes", this.hasFeatureTypes() ? this.featureTypesAsStrings() : null).add("ClientRequestToken", (Object)this.clientRequestToken()).add("JobTag", (Object)this.jobTag()).add("NotificationChannel", (Object)this.notificationChannel()).add("OutputConfig", (Object)this.outputConfig()).add("KMSKeyId", (Object)this.kmsKeyId()).add("QueriesConfig", (Object)this.queriesConfig()).add("AdaptersConfig", (Object)this.adaptersConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentLocation": {
                return Optional.ofNullable(clazz.cast(this.documentLocation()));
            }
            case "FeatureTypes": {
                return Optional.ofNullable(clazz.cast(this.featureTypesAsStrings()));
            }
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "JobTag": {
                return Optional.ofNullable(clazz.cast(this.jobTag()));
            }
            case "NotificationChannel": {
                return Optional.ofNullable(clazz.cast(this.notificationChannel()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "KMSKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "QueriesConfig": {
                return Optional.ofNullable(clazz.cast(this.queriesConfig()));
            }
            case "AdaptersConfig": {
                return Optional.ofNullable(clazz.cast(this.adaptersConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DocumentLocation", DOCUMENT_LOCATION_FIELD);
        map.put("FeatureTypes", FEATURE_TYPES_FIELD);
        map.put("ClientRequestToken", CLIENT_REQUEST_TOKEN_FIELD);
        map.put("JobTag", JOB_TAG_FIELD);
        map.put("NotificationChannel", NOTIFICATION_CHANNEL_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("KMSKeyId", KMS_KEY_ID_FIELD);
        map.put("QueriesConfig", QUERIES_CONFIG_FIELD);
        map.put("AdaptersConfig", ADAPTERS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDocumentAnalysisRequest, T> g) {
        return obj -> g.apply((StartDocumentAnalysisRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractRequest.BuilderImpl
    implements Builder {
        private DocumentLocation documentLocation;
        private List<String> featureTypes = DefaultSdkAutoConstructList.getInstance();
        private String clientRequestToken;
        private String jobTag;
        private NotificationChannel notificationChannel;
        private OutputConfig outputConfig;
        private String kmsKeyId;
        private QueriesConfig queriesConfig;
        private AdaptersConfig adaptersConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDocumentAnalysisRequest model) {
            super(model);
            this.documentLocation(model.documentLocation);
            this.featureTypesWithStrings(model.featureTypes);
            this.clientRequestToken(model.clientRequestToken);
            this.jobTag(model.jobTag);
            this.notificationChannel(model.notificationChannel);
            this.outputConfig(model.outputConfig);
            this.kmsKeyId(model.kmsKeyId);
            this.queriesConfig(model.queriesConfig);
            this.adaptersConfig(model.adaptersConfig);
        }

        public final DocumentLocation.Builder getDocumentLocation() {
            return this.documentLocation != null ? this.documentLocation.toBuilder() : null;
        }

        public final void setDocumentLocation(DocumentLocation.BuilderImpl documentLocation) {
            this.documentLocation = documentLocation != null ? documentLocation.build() : null;
        }

        @Override
        public final Builder documentLocation(DocumentLocation documentLocation) {
            this.documentLocation = documentLocation;
            return this;
        }

        public final Collection<String> getFeatureTypes() {
            if (this.featureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.featureTypes;
        }

        public final void setFeatureTypes(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
        }

        @Override
        public final Builder featureTypesWithStrings(Collection<String> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copy(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypesWithStrings(String ... featureTypes) {
            this.featureTypesWithStrings(Arrays.asList(featureTypes));
            return this;
        }

        @Override
        public final Builder featureTypes(Collection<FeatureType> featureTypes) {
            this.featureTypes = FeatureTypesCopier.copyEnumToString(featureTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder featureTypes(FeatureType ... featureTypes) {
            this.featureTypes(Arrays.asList(featureTypes));
            return this;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final String getJobTag() {
            return this.jobTag;
        }

        public final void setJobTag(String jobTag) {
            this.jobTag = jobTag;
        }

        @Override
        public final Builder jobTag(String jobTag) {
            this.jobTag = jobTag;
            return this;
        }

        public final NotificationChannel.Builder getNotificationChannel() {
            return this.notificationChannel != null ? this.notificationChannel.toBuilder() : null;
        }

        public final void setNotificationChannel(NotificationChannel.BuilderImpl notificationChannel) {
            this.notificationChannel = notificationChannel != null ? notificationChannel.build() : null;
        }

        @Override
        public final Builder notificationChannel(NotificationChannel notificationChannel) {
            this.notificationChannel = notificationChannel;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final QueriesConfig.Builder getQueriesConfig() {
            return this.queriesConfig != null ? this.queriesConfig.toBuilder() : null;
        }

        public final void setQueriesConfig(QueriesConfig.BuilderImpl queriesConfig) {
            this.queriesConfig = queriesConfig != null ? queriesConfig.build() : null;
        }

        @Override
        public final Builder queriesConfig(QueriesConfig queriesConfig) {
            this.queriesConfig = queriesConfig;
            return this;
        }

        public final AdaptersConfig.Builder getAdaptersConfig() {
            return this.adaptersConfig != null ? this.adaptersConfig.toBuilder() : null;
        }

        public final void setAdaptersConfig(AdaptersConfig.BuilderImpl adaptersConfig) {
            this.adaptersConfig = adaptersConfig != null ? adaptersConfig.build() : null;
        }

        @Override
        public final Builder adaptersConfig(AdaptersConfig adaptersConfig) {
            this.adaptersConfig = adaptersConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDocumentAnalysisRequest build() {
            return new StartDocumentAnalysisRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TextractRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartDocumentAnalysisRequest> {
        public Builder documentLocation(DocumentLocation var1);

        default public Builder documentLocation(Consumer<DocumentLocation.Builder> documentLocation) {
            return this.documentLocation((DocumentLocation)((DocumentLocation.Builder)DocumentLocation.builder().applyMutation(documentLocation)).build());
        }

        public Builder featureTypesWithStrings(Collection<String> var1);

        public Builder featureTypesWithStrings(String ... var1);

        public Builder featureTypes(Collection<FeatureType> var1);

        public Builder featureTypes(FeatureType ... var1);

        public Builder clientRequestToken(String var1);

        public Builder jobTag(String var1);

        public Builder notificationChannel(NotificationChannel var1);

        default public Builder notificationChannel(Consumer<NotificationChannel.Builder> notificationChannel) {
            return this.notificationChannel((NotificationChannel)((NotificationChannel.Builder)NotificationChannel.builder().applyMutation(notificationChannel)).build());
        }

        public Builder outputConfig(OutputConfig var1);

        default public Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return this.outputConfig((OutputConfig)((OutputConfig.Builder)OutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder kmsKeyId(String var1);

        public Builder queriesConfig(QueriesConfig var1);

        default public Builder queriesConfig(Consumer<QueriesConfig.Builder> queriesConfig) {
            return this.queriesConfig((QueriesConfig)((QueriesConfig.Builder)QueriesConfig.builder().applyMutation(queriesConfig)).build());
        }

        public Builder adaptersConfig(AdaptersConfig var1);

        default public Builder adaptersConfig(Consumer<AdaptersConfig.Builder> adaptersConfig) {
            return this.adaptersConfig((AdaptersConfig)((AdaptersConfig.Builder)AdaptersConfig.builder().applyMutation(adaptersConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

