/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BlockType {
    KEY_VALUE_SET("KEY_VALUE_SET"),
    PAGE("PAGE"),
    LINE("LINE"),
    WORD("WORD"),
    TABLE("TABLE"),
    CELL("CELL"),
    SELECTION_ELEMENT("SELECTION_ELEMENT"),
    MERGED_CELL("MERGED_CELL"),
    TITLE("TITLE"),
    QUERY("QUERY"),
    QUERY_RESULT("QUERY_RESULT"),
    SIGNATURE("SIGNATURE"),
    TABLE_TITLE("TABLE_TITLE"),
    TABLE_FOOTER("TABLE_FOOTER"),
    LAYOUT_TEXT("LAYOUT_TEXT"),
    LAYOUT_TITLE("LAYOUT_TITLE"),
    LAYOUT_HEADER("LAYOUT_HEADER"),
    LAYOUT_FOOTER("LAYOUT_FOOTER"),
    LAYOUT_SECTION_HEADER("LAYOUT_SECTION_HEADER"),
    LAYOUT_PAGE_NUMBER("LAYOUT_PAGE_NUMBER"),
    LAYOUT_LIST("LAYOUT_LIST"),
    LAYOUT_FIGURE("LAYOUT_FIGURE"),
    LAYOUT_TABLE("LAYOUT_TABLE"),
    LAYOUT_KEY_VALUE("LAYOUT_KEY_VALUE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BlockType> VALUE_MAP;
    private final String value;

    private BlockType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BlockType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BlockType> knownValues() {
        EnumSet<BlockType> knownValues = EnumSet.allOf(BlockType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BlockType.class, BlockType::toString);
    }
}

