/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.textract.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.textract.model.DocumentMetadata;
import software.amazon.awssdk.services.textract.model.ExpenseDocument;
import software.amazon.awssdk.services.textract.model.ExpenseDocumentListCopier;
import software.amazon.awssdk.services.textract.model.TextractResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AnalyzeExpenseResponse
extends TextractResponse
implements ToCopyableBuilder<Builder, AnalyzeExpenseResponse> {
    private static final SdkField<DocumentMetadata> DOCUMENT_METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DocumentMetadata").getter(AnalyzeExpenseResponse.getter(AnalyzeExpenseResponse::documentMetadata)).setter(AnalyzeExpenseResponse.setter(Builder::documentMetadata)).constructor(DocumentMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DocumentMetadata").build()}).build();
    private static final SdkField<List<ExpenseDocument>> EXPENSE_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ExpenseDocuments").getter(AnalyzeExpenseResponse.getter(AnalyzeExpenseResponse::expenseDocuments)).setter(AnalyzeExpenseResponse.setter(Builder::expenseDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpenseDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExpenseDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOCUMENT_METADATA_FIELD, EXPENSE_DOCUMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AnalyzeExpenseResponse.memberNameToFieldInitializer();
    private final DocumentMetadata documentMetadata;
    private final List<ExpenseDocument> expenseDocuments;

    private AnalyzeExpenseResponse(BuilderImpl builder) {
        super(builder);
        this.documentMetadata = builder.documentMetadata;
        this.expenseDocuments = builder.expenseDocuments;
    }

    public final DocumentMetadata documentMetadata() {
        return this.documentMetadata;
    }

    public final boolean hasExpenseDocuments() {
        return this.expenseDocuments != null && !(this.expenseDocuments instanceof SdkAutoConstructList);
    }

    public final List<ExpenseDocument> expenseDocuments() {
        return this.expenseDocuments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.documentMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExpenseDocuments() ? this.expenseDocuments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzeExpenseResponse)) {
            return false;
        }
        AnalyzeExpenseResponse other = (AnalyzeExpenseResponse)((Object)obj);
        return Objects.equals(this.documentMetadata(), other.documentMetadata()) && this.hasExpenseDocuments() == other.hasExpenseDocuments() && Objects.equals(this.expenseDocuments(), other.expenseDocuments());
    }

    public final String toString() {
        return ToString.builder((String)"AnalyzeExpenseResponse").add("DocumentMetadata", (Object)this.documentMetadata()).add("ExpenseDocuments", this.hasExpenseDocuments() ? this.expenseDocuments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DocumentMetadata": {
                return Optional.ofNullable(clazz.cast(this.documentMetadata()));
            }
            case "ExpenseDocuments": {
                return Optional.ofNullable(clazz.cast(this.expenseDocuments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DocumentMetadata", DOCUMENT_METADATA_FIELD);
        map.put("ExpenseDocuments", EXPENSE_DOCUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnalyzeExpenseResponse, T> g) {
        return obj -> g.apply((AnalyzeExpenseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends TextractResponse.BuilderImpl
    implements Builder {
        private DocumentMetadata documentMetadata;
        private List<ExpenseDocument> expenseDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzeExpenseResponse model) {
            super(model);
            this.documentMetadata(model.documentMetadata);
            this.expenseDocuments(model.expenseDocuments);
        }

        public final DocumentMetadata.Builder getDocumentMetadata() {
            return this.documentMetadata != null ? this.documentMetadata.toBuilder() : null;
        }

        public final void setDocumentMetadata(DocumentMetadata.BuilderImpl documentMetadata) {
            this.documentMetadata = documentMetadata != null ? documentMetadata.build() : null;
        }

        @Override
        public final Builder documentMetadata(DocumentMetadata documentMetadata) {
            this.documentMetadata = documentMetadata;
            return this;
        }

        public final List<ExpenseDocument.Builder> getExpenseDocuments() {
            List<ExpenseDocument.Builder> result = ExpenseDocumentListCopier.copyToBuilder(this.expenseDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExpenseDocuments(Collection<ExpenseDocument.BuilderImpl> expenseDocuments) {
            this.expenseDocuments = ExpenseDocumentListCopier.copyFromBuilder(expenseDocuments);
        }

        @Override
        public final Builder expenseDocuments(Collection<ExpenseDocument> expenseDocuments) {
            this.expenseDocuments = ExpenseDocumentListCopier.copy(expenseDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expenseDocuments(ExpenseDocument ... expenseDocuments) {
            this.expenseDocuments(Arrays.asList(expenseDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expenseDocuments(Consumer<ExpenseDocument.Builder> ... expenseDocuments) {
            this.expenseDocuments(Stream.of(expenseDocuments).map(c -> (ExpenseDocument)((ExpenseDocument.Builder)ExpenseDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AnalyzeExpenseResponse build() {
            return new AnalyzeExpenseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends TextractResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AnalyzeExpenseResponse> {
        public Builder documentMetadata(DocumentMetadata var1);

        default public Builder documentMetadata(Consumer<DocumentMetadata.Builder> documentMetadata) {
            return this.documentMetadata((DocumentMetadata)((DocumentMetadata.Builder)DocumentMetadata.builder().applyMutation(documentMetadata)).build());
        }

        public Builder expenseDocuments(Collection<ExpenseDocument> var1);

        public Builder expenseDocuments(ExpenseDocument ... var1);

        public Builder expenseDocuments(Consumer<ExpenseDocument.Builder> ... var1);
    }
}

