/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FederationProtocol {
    SAML("SAML"),
    OAUTH("OAUTH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FederationProtocol> VALUE_MAP;
    private final String value;

    private FederationProtocol(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FederationProtocol fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FederationProtocol> knownValues() {
        EnumSet<FederationProtocol> knownValues = EnumSet.allOf(FederationProtocol.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FederationProtocol.class, FederationProtocol::toString);
    }
}

