/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ssoadmin.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ssoadmin.model.DisplayData;
import software.amazon.awssdk.services.ssoadmin.model.FederationProtocol;
import software.amazon.awssdk.services.ssoadmin.model.ResourceServerConfig;
import software.amazon.awssdk.services.ssoadmin.model.SsoAdminResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationProviderResponse
extends SsoAdminResponse
implements ToCopyableBuilder<Builder, DescribeApplicationProviderResponse> {
    private static final SdkField<String> APPLICATION_PROVIDER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationProviderArn").getter(DescribeApplicationProviderResponse.getter(DescribeApplicationProviderResponse::applicationProviderArn)).setter(DescribeApplicationProviderResponse.setter(Builder::applicationProviderArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationProviderArn").build()}).build();
    private static final SdkField<DisplayData> DISPLAY_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DisplayData").getter(DescribeApplicationProviderResponse.getter(DescribeApplicationProviderResponse::displayData)).setter(DescribeApplicationProviderResponse.setter(Builder::displayData)).constructor(DisplayData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayData").build()}).build();
    private static final SdkField<String> FEDERATION_PROTOCOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FederationProtocol").getter(DescribeApplicationProviderResponse.getter(DescribeApplicationProviderResponse::federationProtocolAsString)).setter(DescribeApplicationProviderResponse.setter(Builder::federationProtocol)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederationProtocol").build()}).build();
    private static final SdkField<ResourceServerConfig> RESOURCE_SERVER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceServerConfig").getter(DescribeApplicationProviderResponse.getter(DescribeApplicationProviderResponse::resourceServerConfig)).setter(DescribeApplicationProviderResponse.setter(Builder::resourceServerConfig)).constructor(ResourceServerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceServerConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_PROVIDER_ARN_FIELD, DISPLAY_DATA_FIELD, FEDERATION_PROTOCOL_FIELD, RESOURCE_SERVER_CONFIG_FIELD));
    private final String applicationProviderArn;
    private final DisplayData displayData;
    private final String federationProtocol;
    private final ResourceServerConfig resourceServerConfig;

    private DescribeApplicationProviderResponse(BuilderImpl builder) {
        super(builder);
        this.applicationProviderArn = builder.applicationProviderArn;
        this.displayData = builder.displayData;
        this.federationProtocol = builder.federationProtocol;
        this.resourceServerConfig = builder.resourceServerConfig;
    }

    public final String applicationProviderArn() {
        return this.applicationProviderArn;
    }

    public final DisplayData displayData() {
        return this.displayData;
    }

    public final FederationProtocol federationProtocol() {
        return FederationProtocol.fromValue(this.federationProtocol);
    }

    public final String federationProtocolAsString() {
        return this.federationProtocol;
    }

    public final ResourceServerConfig resourceServerConfig() {
        return this.resourceServerConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationProviderArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayData());
        hashCode = 31 * hashCode + Objects.hashCode(this.federationProtocolAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceServerConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationProviderResponse)) {
            return false;
        }
        DescribeApplicationProviderResponse other = (DescribeApplicationProviderResponse)((Object)obj);
        return Objects.equals(this.applicationProviderArn(), other.applicationProviderArn()) && Objects.equals(this.displayData(), other.displayData()) && Objects.equals(this.federationProtocolAsString(), other.federationProtocolAsString()) && Objects.equals(this.resourceServerConfig(), other.resourceServerConfig());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeApplicationProviderResponse").add("ApplicationProviderArn", (Object)this.applicationProviderArn()).add("DisplayData", (Object)this.displayData()).add("FederationProtocol", (Object)this.federationProtocolAsString()).add("ResourceServerConfig", (Object)this.resourceServerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationProviderArn": {
                return Optional.ofNullable(clazz.cast(this.applicationProviderArn()));
            }
            case "DisplayData": {
                return Optional.ofNullable(clazz.cast(this.displayData()));
            }
            case "FederationProtocol": {
                return Optional.ofNullable(clazz.cast(this.federationProtocolAsString()));
            }
            case "ResourceServerConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceServerConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeApplicationProviderResponse, T> g) {
        return obj -> g.apply((DescribeApplicationProviderResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SsoAdminResponse.BuilderImpl
    implements Builder {
        private String applicationProviderArn;
        private DisplayData displayData;
        private String federationProtocol;
        private ResourceServerConfig resourceServerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationProviderResponse model) {
            super(model);
            this.applicationProviderArn(model.applicationProviderArn);
            this.displayData(model.displayData);
            this.federationProtocol(model.federationProtocol);
            this.resourceServerConfig(model.resourceServerConfig);
        }

        public final String getApplicationProviderArn() {
            return this.applicationProviderArn;
        }

        public final void setApplicationProviderArn(String applicationProviderArn) {
            this.applicationProviderArn = applicationProviderArn;
        }

        @Override
        public final Builder applicationProviderArn(String applicationProviderArn) {
            this.applicationProviderArn = applicationProviderArn;
            return this;
        }

        public final DisplayData.Builder getDisplayData() {
            return this.displayData != null ? this.displayData.toBuilder() : null;
        }

        public final void setDisplayData(DisplayData.BuilderImpl displayData) {
            this.displayData = displayData != null ? displayData.build() : null;
        }

        @Override
        public final Builder displayData(DisplayData displayData) {
            this.displayData = displayData;
            return this;
        }

        public final String getFederationProtocol() {
            return this.federationProtocol;
        }

        public final void setFederationProtocol(String federationProtocol) {
            this.federationProtocol = federationProtocol;
        }

        @Override
        public final Builder federationProtocol(String federationProtocol) {
            this.federationProtocol = federationProtocol;
            return this;
        }

        @Override
        public final Builder federationProtocol(FederationProtocol federationProtocol) {
            this.federationProtocol(federationProtocol == null ? null : federationProtocol.toString());
            return this;
        }

        public final ResourceServerConfig.Builder getResourceServerConfig() {
            return this.resourceServerConfig != null ? this.resourceServerConfig.toBuilder() : null;
        }

        public final void setResourceServerConfig(ResourceServerConfig.BuilderImpl resourceServerConfig) {
            this.resourceServerConfig = resourceServerConfig != null ? resourceServerConfig.build() : null;
        }

        @Override
        public final Builder resourceServerConfig(ResourceServerConfig resourceServerConfig) {
            this.resourceServerConfig = resourceServerConfig;
            return this;
        }

        @Override
        public DescribeApplicationProviderResponse build() {
            return new DescribeApplicationProviderResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SsoAdminResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeApplicationProviderResponse> {
        public Builder applicationProviderArn(String var1);

        public Builder displayData(DisplayData var1);

        default public Builder displayData(Consumer<DisplayData.Builder> displayData) {
            return this.displayData((DisplayData)((DisplayData.Builder)DisplayData.builder().applyMutation(displayData)).build());
        }

        public Builder federationProtocol(String var1);

        public Builder federationProtocol(FederationProtocol var1);

        public Builder resourceServerConfig(ResourceServerConfig var1);

        default public Builder resourceServerConfig(Consumer<ResourceServerConfig.Builder> resourceServerConfig) {
            return this.resourceServerConfig((ResourceServerConfig)((ResourceServerConfig.Builder)ResourceServerConfig.builder().applyMutation(resourceServerConfig)).build());
        }
    }
}

