/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ses.model.BehaviorOnMXFailure;
import software.amazon.awssdk.services.ses.model.SesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SetIdentityMailFromDomainRequest
extends SesRequest
implements ToCopyableBuilder<Builder, SetIdentityMailFromDomainRequest> {
    private static final SdkField<String> IDENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Identity").getter(SetIdentityMailFromDomainRequest.getter(SetIdentityMailFromDomainRequest::identity)).setter(SetIdentityMailFromDomainRequest.setter(Builder::identity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identity").build()}).build();
    private static final SdkField<String> MAIL_FROM_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MailFromDomain").getter(SetIdentityMailFromDomainRequest.getter(SetIdentityMailFromDomainRequest::mailFromDomain)).setter(SetIdentityMailFromDomainRequest.setter(Builder::mailFromDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MailFromDomain").build()}).build();
    private static final SdkField<String> BEHAVIOR_ON_MX_FAILURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BehaviorOnMXFailure").getter(SetIdentityMailFromDomainRequest.getter(SetIdentityMailFromDomainRequest::behaviorOnMXFailureAsString)).setter(SetIdentityMailFromDomainRequest.setter(Builder::behaviorOnMXFailure)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BehaviorOnMXFailure").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTITY_FIELD, MAIL_FROM_DOMAIN_FIELD, BEHAVIOR_ON_MX_FAILURE_FIELD));
    private final String identity;
    private final String mailFromDomain;
    private final String behaviorOnMXFailure;

    private SetIdentityMailFromDomainRequest(BuilderImpl builder) {
        super(builder);
        this.identity = builder.identity;
        this.mailFromDomain = builder.mailFromDomain;
        this.behaviorOnMXFailure = builder.behaviorOnMXFailure;
    }

    public final String identity() {
        return this.identity;
    }

    public final String mailFromDomain() {
        return this.mailFromDomain;
    }

    public final BehaviorOnMXFailure behaviorOnMXFailure() {
        return BehaviorOnMXFailure.fromValue(this.behaviorOnMXFailure);
    }

    public final String behaviorOnMXFailureAsString() {
        return this.behaviorOnMXFailure;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.identity());
        hashCode = 31 * hashCode + Objects.hashCode(this.mailFromDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.behaviorOnMXFailureAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SetIdentityMailFromDomainRequest)) {
            return false;
        }
        SetIdentityMailFromDomainRequest other = (SetIdentityMailFromDomainRequest)((Object)obj);
        return Objects.equals(this.identity(), other.identity()) && Objects.equals(this.mailFromDomain(), other.mailFromDomain()) && Objects.equals(this.behaviorOnMXFailureAsString(), other.behaviorOnMXFailureAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SetIdentityMailFromDomainRequest").add("Identity", (Object)this.identity()).add("MailFromDomain", (Object)this.mailFromDomain()).add("BehaviorOnMXFailure", (Object)this.behaviorOnMXFailureAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Identity": {
                return Optional.ofNullable(clazz.cast(this.identity()));
            }
            case "MailFromDomain": {
                return Optional.ofNullable(clazz.cast(this.mailFromDomain()));
            }
            case "BehaviorOnMXFailure": {
                return Optional.ofNullable(clazz.cast(this.behaviorOnMXFailureAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SetIdentityMailFromDomainRequest, T> g) {
        return obj -> g.apply((SetIdentityMailFromDomainRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesRequest.BuilderImpl
    implements Builder {
        private String identity;
        private String mailFromDomain;
        private String behaviorOnMXFailure;

        private BuilderImpl() {
        }

        private BuilderImpl(SetIdentityMailFromDomainRequest model) {
            super(model);
            this.identity(model.identity);
            this.mailFromDomain(model.mailFromDomain);
            this.behaviorOnMXFailure(model.behaviorOnMXFailure);
        }

        public final String getIdentity() {
            return this.identity;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        @Override
        @Transient
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final String getMailFromDomain() {
            return this.mailFromDomain;
        }

        public final void setMailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
        }

        @Override
        @Transient
        public final Builder mailFromDomain(String mailFromDomain) {
            this.mailFromDomain = mailFromDomain;
            return this;
        }

        public final String getBehaviorOnMXFailure() {
            return this.behaviorOnMXFailure;
        }

        public final void setBehaviorOnMXFailure(String behaviorOnMXFailure) {
            this.behaviorOnMXFailure = behaviorOnMXFailure;
        }

        @Override
        @Transient
        public final Builder behaviorOnMXFailure(String behaviorOnMXFailure) {
            this.behaviorOnMXFailure = behaviorOnMXFailure;
            return this;
        }

        @Override
        @Transient
        public final Builder behaviorOnMXFailure(BehaviorOnMXFailure behaviorOnMXFailure) {
            this.behaviorOnMXFailure(behaviorOnMXFailure == null ? null : behaviorOnMXFailure.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SetIdentityMailFromDomainRequest build() {
            return new SetIdentityMailFromDomainRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SetIdentityMailFromDomainRequest> {
        public Builder identity(String var1);

        public Builder mailFromDomain(String var1);

        public Builder behaviorOnMXFailure(String var1);

        public Builder behaviorOnMXFailure(BehaviorOnMXFailure var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

