/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.BulkEmailDestinationStatus;
import software.amazon.awssdk.services.ses.model.BulkEmailDestinationStatusListCopier;
import software.amazon.awssdk.services.ses.model.SesResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SendBulkTemplatedEmailResponse
extends SesResponse
implements ToCopyableBuilder<Builder, SendBulkTemplatedEmailResponse> {
    private static final SdkField<List<BulkEmailDestinationStatus>> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Status").getter(SendBulkTemplatedEmailResponse.getter(SendBulkTemplatedEmailResponse::status)).setter(SendBulkTemplatedEmailResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BulkEmailDestinationStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD));
    private final List<BulkEmailDestinationStatus> status;

    private SendBulkTemplatedEmailResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
    }

    public final boolean hasStatus() {
        return this.status != null && !(this.status instanceof SdkAutoConstructList);
    }

    public final List<BulkEmailDestinationStatus> status() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatus() ? this.status() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SendBulkTemplatedEmailResponse)) {
            return false;
        }
        SendBulkTemplatedEmailResponse other = (SendBulkTemplatedEmailResponse)((Object)obj);
        return this.hasStatus() == other.hasStatus() && Objects.equals(this.status(), other.status());
    }

    public final String toString() {
        return ToString.builder((String)"SendBulkTemplatedEmailResponse").add("Status", this.hasStatus() ? this.status() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SendBulkTemplatedEmailResponse, T> g) {
        return obj -> g.apply((SendBulkTemplatedEmailResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesResponse.BuilderImpl
    implements Builder {
        private List<BulkEmailDestinationStatus> status = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SendBulkTemplatedEmailResponse model) {
            super(model);
            this.status(model.status);
        }

        public final List<BulkEmailDestinationStatus.Builder> getStatus() {
            List<BulkEmailDestinationStatus.Builder> result = BulkEmailDestinationStatusListCopier.copyToBuilder(this.status);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatus(Collection<BulkEmailDestinationStatus.BuilderImpl> status) {
            this.status = BulkEmailDestinationStatusListCopier.copyFromBuilder(status);
        }

        @Override
        @Transient
        public final Builder status(Collection<BulkEmailDestinationStatus> status) {
            this.status = BulkEmailDestinationStatusListCopier.copy(status);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder status(BulkEmailDestinationStatus ... status) {
            this.status(Arrays.asList(status));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder status(Consumer<BulkEmailDestinationStatus.Builder> ... status) {
            this.status(Stream.of(status).map(c -> (BulkEmailDestinationStatus)((BulkEmailDestinationStatus.Builder)BulkEmailDestinationStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SendBulkTemplatedEmailResponse build() {
            return new SendBulkTemplatedEmailResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SendBulkTemplatedEmailResponse> {
        public Builder status(Collection<BulkEmailDestinationStatus> var1);

        public Builder status(BulkEmailDestinationStatus ... var1);

        public Builder status(Consumer<BulkEmailDestinationStatus.Builder> ... var1);
    }
}

