/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ses.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ses.model.ConfigurationSet;
import software.amazon.awssdk.services.ses.model.DeliveryOptions;
import software.amazon.awssdk.services.ses.model.EventDestination;
import software.amazon.awssdk.services.ses.model.EventDestinationsCopier;
import software.amazon.awssdk.services.ses.model.ReputationOptions;
import software.amazon.awssdk.services.ses.model.SesResponse;
import software.amazon.awssdk.services.ses.model.TrackingOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeConfigurationSetResponse
extends SesResponse
implements ToCopyableBuilder<Builder, DescribeConfigurationSetResponse> {
    private static final SdkField<ConfigurationSet> CONFIGURATION_SET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConfigurationSet").getter(DescribeConfigurationSetResponse.getter(DescribeConfigurationSetResponse::configurationSet)).setter(DescribeConfigurationSetResponse.setter(Builder::configurationSet)).constructor(ConfigurationSet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationSet").build()}).build();
    private static final SdkField<List<EventDestination>> EVENT_DESTINATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventDestinations").getter(DescribeConfigurationSetResponse.getter(DescribeConfigurationSetResponse::eventDestinations)).setter(DescribeConfigurationSetResponse.setter(Builder::eventDestinations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDestinations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventDestination::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TrackingOptions> TRACKING_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TrackingOptions").getter(DescribeConfigurationSetResponse.getter(DescribeConfigurationSetResponse::trackingOptions)).setter(DescribeConfigurationSetResponse.setter(Builder::trackingOptions)).constructor(TrackingOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrackingOptions").build()}).build();
    private static final SdkField<DeliveryOptions> DELIVERY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeliveryOptions").getter(DescribeConfigurationSetResponse.getter(DescribeConfigurationSetResponse::deliveryOptions)).setter(DescribeConfigurationSetResponse.setter(Builder::deliveryOptions)).constructor(DeliveryOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryOptions").build()}).build();
    private static final SdkField<ReputationOptions> REPUTATION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReputationOptions").getter(DescribeConfigurationSetResponse.getter(DescribeConfigurationSetResponse::reputationOptions)).setter(DescribeConfigurationSetResponse.setter(Builder::reputationOptions)).constructor(ReputationOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReputationOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONFIGURATION_SET_FIELD, EVENT_DESTINATIONS_FIELD, TRACKING_OPTIONS_FIELD, DELIVERY_OPTIONS_FIELD, REPUTATION_OPTIONS_FIELD));
    private final ConfigurationSet configurationSet;
    private final List<EventDestination> eventDestinations;
    private final TrackingOptions trackingOptions;
    private final DeliveryOptions deliveryOptions;
    private final ReputationOptions reputationOptions;

    private DescribeConfigurationSetResponse(BuilderImpl builder) {
        super(builder);
        this.configurationSet = builder.configurationSet;
        this.eventDestinations = builder.eventDestinations;
        this.trackingOptions = builder.trackingOptions;
        this.deliveryOptions = builder.deliveryOptions;
        this.reputationOptions = builder.reputationOptions;
    }

    public final ConfigurationSet configurationSet() {
        return this.configurationSet;
    }

    public final boolean hasEventDestinations() {
        return this.eventDestinations != null && !(this.eventDestinations instanceof SdkAutoConstructList);
    }

    public final List<EventDestination> eventDestinations() {
        return this.eventDestinations;
    }

    public final TrackingOptions trackingOptions() {
        return this.trackingOptions;
    }

    public final DeliveryOptions deliveryOptions() {
        return this.deliveryOptions;
    }

    public final ReputationOptions reputationOptions() {
        return this.reputationOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationSet());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventDestinations() ? this.eventDestinations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.trackingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.deliveryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.reputationOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeConfigurationSetResponse)) {
            return false;
        }
        DescribeConfigurationSetResponse other = (DescribeConfigurationSetResponse)((Object)obj);
        return Objects.equals(this.configurationSet(), other.configurationSet()) && this.hasEventDestinations() == other.hasEventDestinations() && Objects.equals(this.eventDestinations(), other.eventDestinations()) && Objects.equals(this.trackingOptions(), other.trackingOptions()) && Objects.equals(this.deliveryOptions(), other.deliveryOptions()) && Objects.equals(this.reputationOptions(), other.reputationOptions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeConfigurationSetResponse").add("ConfigurationSet", (Object)this.configurationSet()).add("EventDestinations", this.hasEventDestinations() ? this.eventDestinations() : null).add("TrackingOptions", (Object)this.trackingOptions()).add("DeliveryOptions", (Object)this.deliveryOptions()).add("ReputationOptions", (Object)this.reputationOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConfigurationSet": {
                return Optional.ofNullable(clazz.cast(this.configurationSet()));
            }
            case "EventDestinations": {
                return Optional.ofNullable(clazz.cast(this.eventDestinations()));
            }
            case "TrackingOptions": {
                return Optional.ofNullable(clazz.cast(this.trackingOptions()));
            }
            case "DeliveryOptions": {
                return Optional.ofNullable(clazz.cast(this.deliveryOptions()));
            }
            case "ReputationOptions": {
                return Optional.ofNullable(clazz.cast(this.reputationOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeConfigurationSetResponse, T> g) {
        return obj -> g.apply((DescribeConfigurationSetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SesResponse.BuilderImpl
    implements Builder {
        private ConfigurationSet configurationSet;
        private List<EventDestination> eventDestinations = DefaultSdkAutoConstructList.getInstance();
        private TrackingOptions trackingOptions;
        private DeliveryOptions deliveryOptions;
        private ReputationOptions reputationOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeConfigurationSetResponse model) {
            super(model);
            this.configurationSet(model.configurationSet);
            this.eventDestinations(model.eventDestinations);
            this.trackingOptions(model.trackingOptions);
            this.deliveryOptions(model.deliveryOptions);
            this.reputationOptions(model.reputationOptions);
        }

        public final ConfigurationSet.Builder getConfigurationSet() {
            return this.configurationSet != null ? this.configurationSet.toBuilder() : null;
        }

        public final void setConfigurationSet(ConfigurationSet.BuilderImpl configurationSet) {
            this.configurationSet = configurationSet != null ? configurationSet.build() : null;
        }

        @Override
        @Transient
        public final Builder configurationSet(ConfigurationSet configurationSet) {
            this.configurationSet = configurationSet;
            return this;
        }

        public final List<EventDestination.Builder> getEventDestinations() {
            List<EventDestination.Builder> result = EventDestinationsCopier.copyToBuilder(this.eventDestinations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventDestinations(Collection<EventDestination.BuilderImpl> eventDestinations) {
            this.eventDestinations = EventDestinationsCopier.copyFromBuilder(eventDestinations);
        }

        @Override
        @Transient
        public final Builder eventDestinations(Collection<EventDestination> eventDestinations) {
            this.eventDestinations = EventDestinationsCopier.copy(eventDestinations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventDestinations(EventDestination ... eventDestinations) {
            this.eventDestinations(Arrays.asList(eventDestinations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventDestinations(Consumer<EventDestination.Builder> ... eventDestinations) {
            this.eventDestinations(Stream.of(eventDestinations).map(c -> (EventDestination)((EventDestination.Builder)EventDestination.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TrackingOptions.Builder getTrackingOptions() {
            return this.trackingOptions != null ? this.trackingOptions.toBuilder() : null;
        }

        public final void setTrackingOptions(TrackingOptions.BuilderImpl trackingOptions) {
            this.trackingOptions = trackingOptions != null ? trackingOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder trackingOptions(TrackingOptions trackingOptions) {
            this.trackingOptions = trackingOptions;
            return this;
        }

        public final DeliveryOptions.Builder getDeliveryOptions() {
            return this.deliveryOptions != null ? this.deliveryOptions.toBuilder() : null;
        }

        public final void setDeliveryOptions(DeliveryOptions.BuilderImpl deliveryOptions) {
            this.deliveryOptions = deliveryOptions != null ? deliveryOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder deliveryOptions(DeliveryOptions deliveryOptions) {
            this.deliveryOptions = deliveryOptions;
            return this;
        }

        public final ReputationOptions.Builder getReputationOptions() {
            return this.reputationOptions != null ? this.reputationOptions.toBuilder() : null;
        }

        public final void setReputationOptions(ReputationOptions.BuilderImpl reputationOptions) {
            this.reputationOptions = reputationOptions != null ? reputationOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder reputationOptions(ReputationOptions reputationOptions) {
            this.reputationOptions = reputationOptions;
            return this;
        }

        @Override
        public DescribeConfigurationSetResponse build() {
            return new DescribeConfigurationSetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SesResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeConfigurationSetResponse> {
        public Builder configurationSet(ConfigurationSet var1);

        default public Builder configurationSet(Consumer<ConfigurationSet.Builder> configurationSet) {
            return this.configurationSet((ConfigurationSet)((ConfigurationSet.Builder)ConfigurationSet.builder().applyMutation(configurationSet)).build());
        }

        public Builder eventDestinations(Collection<EventDestination> var1);

        public Builder eventDestinations(EventDestination ... var1);

        public Builder eventDestinations(Consumer<EventDestination.Builder> ... var1);

        public Builder trackingOptions(TrackingOptions var1);

        default public Builder trackingOptions(Consumer<TrackingOptions.Builder> trackingOptions) {
            return this.trackingOptions((TrackingOptions)((TrackingOptions.Builder)TrackingOptions.builder().applyMutation(trackingOptions)).build());
        }

        public Builder deliveryOptions(DeliveryOptions var1);

        default public Builder deliveryOptions(Consumer<DeliveryOptions.Builder> deliveryOptions) {
            return this.deliveryOptions((DeliveryOptions)((DeliveryOptions.Builder)DeliveryOptions.builder().applyMutation(deliveryOptions)).build());
        }

        public Builder reputationOptions(ReputationOptions var1);

        default public Builder reputationOptions(Consumer<ReputationOptions.Builder> reputationOptions) {
            return this.reputationOptions((ReputationOptions)((ReputationOptions.Builder)ReputationOptions.builder().applyMutation(reputationOptions)).build());
        }
    }
}

