/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.route53recoveryreadiness.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.Route53RecoveryReadinessClient;
import software.amazon.awssdk.services.route53recoveryreadiness.internal.UserAgentUtils;
import software.amazon.awssdk.services.route53recoveryreadiness.model.CellOutput;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListCellsRequest;
import software.amazon.awssdk.services.route53recoveryreadiness.model.ListCellsResponse;

public class ListCellsIterable
implements SdkIterable<ListCellsResponse> {
    private final Route53RecoveryReadinessClient client;
    private final ListCellsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCellsIterable(Route53RecoveryReadinessClient client, ListCellsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCellsResponseFetcher();
    }

    public Iterator<ListCellsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CellOutput> cells() {
        Function<ListCellsResponse, Iterator> getIterator = response -> {
            if (response != null && response.cells() != null) {
                return response.cells().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCellsResponseFetcher
    implements SyncPageFetcher<ListCellsResponse> {
        private ListCellsResponseFetcher() {
        }

        public boolean hasNextPage(ListCellsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCellsResponse nextPage(ListCellsResponse previousPage) {
            if (previousPage == null) {
                return ListCellsIterable.this.client.listCells(ListCellsIterable.this.firstRequest);
            }
            return ListCellsIterable.this.client.listCells((ListCellsRequest)((Object)ListCellsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

