/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworkscm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServerStatus {
    BACKING_UP("BACKING_UP"),
    CONNECTION_LOST("CONNECTION_LOST"),
    CREATING("CREATING"),
    DELETING("DELETING"),
    MODIFYING("MODIFYING"),
    FAILED("FAILED"),
    HEALTHY("HEALTHY"),
    RUNNING("RUNNING"),
    RESTORING("RESTORING"),
    SETUP("SETUP"),
    UNDER_MAINTENANCE("UNDER_MAINTENANCE"),
    UNHEALTHY("UNHEALTHY"),
    TERMINATED("TERMINATED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServerStatus> VALUE_MAP;
    private final String value;

    private ServerStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServerStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServerStatus> knownValues() {
        EnumSet<ServerStatus> knownValues = EnumSet.allOf(ServerStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServerStatus.class, ServerStatus::toString);
    }
}

