/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.model.RunStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRunsRequest
extends OmicsRequest
implements ToCopyableBuilder<Builder, ListRunsRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ListRunsRequest.getter(ListRunsRequest::name)).setter(ListRunsRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()}).build();
    private static final SdkField<String> RUN_GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runGroupId").getter(ListRunsRequest.getter(ListRunsRequest::runGroupId)).setter(ListRunsRequest.setter(Builder::runGroupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("runGroupId").build()}).build();
    private static final SdkField<String> STARTING_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("startingToken").getter(ListRunsRequest.getter(ListRunsRequest::startingToken)).setter(ListRunsRequest.setter(Builder::startingToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startingToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListRunsRequest.getter(ListRunsRequest::maxResults)).setter(ListRunsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ListRunsRequest.getter(ListRunsRequest::statusAsString)).setter(ListRunsRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RUN_GROUP_ID_FIELD, STARTING_TOKEN_FIELD, MAX_RESULTS_FIELD, STATUS_FIELD));
    private final String name;
    private final String runGroupId;
    private final String startingToken;
    private final Integer maxResults;
    private final String status;

    private ListRunsRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.runGroupId = builder.runGroupId;
        this.startingToken = builder.startingToken;
        this.maxResults = builder.maxResults;
        this.status = builder.status;
    }

    public final String name() {
        return this.name;
    }

    public final String runGroupId() {
        return this.runGroupId;
    }

    public final String startingToken() {
        return this.startingToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final RunStatus status() {
        return RunStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.runGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(this.startingToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRunsRequest)) {
            return false;
        }
        ListRunsRequest other = (ListRunsRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.runGroupId(), other.runGroupId()) && Objects.equals(this.startingToken(), other.startingToken()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListRunsRequest").add("Name", (Object)this.name()).add("RunGroupId", (Object)this.runGroupId()).add("StartingToken", (Object)this.startingToken()).add("MaxResults", (Object)this.maxResults()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "runGroupId": {
                return Optional.ofNullable(clazz.cast(this.runGroupId()));
            }
            case "startingToken": {
                return Optional.ofNullable(clazz.cast(this.startingToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRunsRequest, T> g) {
        return obj -> g.apply((ListRunsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsRequest.BuilderImpl
    implements Builder {
        private String name;
        private String runGroupId;
        private String startingToken;
        private Integer maxResults;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRunsRequest model) {
            super(model);
            this.name(model.name);
            this.runGroupId(model.runGroupId);
            this.startingToken(model.startingToken);
            this.maxResults(model.maxResults);
            this.status(model.status);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRunGroupId() {
            return this.runGroupId;
        }

        public final void setRunGroupId(String runGroupId) {
            this.runGroupId = runGroupId;
        }

        @Override
        public final Builder runGroupId(String runGroupId) {
            this.runGroupId = runGroupId;
            return this;
        }

        public final String getStartingToken() {
            return this.startingToken;
        }

        public final void setStartingToken(String startingToken) {
            this.startingToken = startingToken;
        }

        @Override
        public final Builder startingToken(String startingToken) {
            this.startingToken = startingToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListRunsRequest build() {
            return new ListRunsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends OmicsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRunsRequest> {
        public Builder name(String var1);

        public Builder runGroupId(String var1);

        public Builder startingToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder status(String var1);

        public Builder status(RunStatus var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

