/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mq.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserResponse extends MqResponse implements
        ToCopyableBuilder<DescribeUserResponse.Builder, DescribeUserResponse> {
    private static final SdkField<String> BROKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BrokerId").getter(getter(DescribeUserResponse::brokerId)).setter(setter(Builder::brokerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerId").build()).build();

    private static final SdkField<Boolean> CONSOLE_ACCESS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ConsoleAccess").getter(getter(DescribeUserResponse::consoleAccess))
            .setter(setter(Builder::consoleAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consoleAccess").build()).build();

    private static final SdkField<List<String>> GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Groups")
            .getter(getter(DescribeUserResponse::groups))
            .setter(setter(Builder::groups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<UserPendingChanges> PENDING_FIELD = SdkField
            .<UserPendingChanges> builder(MarshallingType.SDK_POJO).memberName("Pending")
            .getter(getter(DescribeUserResponse::pending)).setter(setter(Builder::pending))
            .constructor(UserPendingChanges::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pending").build()).build();

    private static final SdkField<String> USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Username").getter(getter(DescribeUserResponse::username)).setter(setter(Builder::username))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("username").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BROKER_ID_FIELD,
            CONSOLE_ACCESS_FIELD, GROUPS_FIELD, PENDING_FIELD, USERNAME_FIELD));

    private final String brokerId;

    private final Boolean consoleAccess;

    private final List<String> groups;

    private final UserPendingChanges pending;

    private final String username;

    private DescribeUserResponse(BuilderImpl builder) {
        super(builder);
        this.brokerId = builder.brokerId;
        this.consoleAccess = builder.consoleAccess;
        this.groups = builder.groups;
        this.pending = builder.pending;
        this.username = builder.username;
    }

    /**
     * Required. The unique ID that Amazon MQ generates for the broker.
     * 
     * @return Required. The unique ID that Amazon MQ generates for the broker.
     */
    public final String brokerId() {
        return brokerId;
    }

    /**
     * Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
     * 
     * @return Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
     */
    public final Boolean consoleAccess() {
        return consoleAccess;
    }

    /**
     * Returns true if the Groups property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasGroups() {
        return groups != null && !(groups instanceof SdkAutoConstructList);
    }

    /**
     * The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric
     * characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only
     *         alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100
     *         characters long.
     */
    public final List<String> groups() {
        return groups;
    }

    /**
     * The status of the changes pending for the ActiveMQ user.
     * 
     * @return The status of the changes pending for the ActiveMQ user.
     */
    public final UserPendingChanges pending() {
        return pending;
    }

    /**
     * Required. The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes,
     * periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
     * 
     * @return Required. The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes,
     *         periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
     */
    public final String username() {
        return username;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(consoleAccess());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroups() ? groups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pending());
        hashCode = 31 * hashCode + Objects.hashCode(username());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserResponse)) {
            return false;
        }
        DescribeUserResponse other = (DescribeUserResponse) obj;
        return Objects.equals(brokerId(), other.brokerId()) && Objects.equals(consoleAccess(), other.consoleAccess())
                && hasGroups() == other.hasGroups() && Objects.equals(groups(), other.groups())
                && Objects.equals(pending(), other.pending()) && Objects.equals(username(), other.username());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUserResponse").add("BrokerId", brokerId()).add("ConsoleAccess", consoleAccess())
                .add("Groups", hasGroups() ? groups() : null).add("Pending", pending()).add("Username", username()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BrokerId":
            return Optional.ofNullable(clazz.cast(brokerId()));
        case "ConsoleAccess":
            return Optional.ofNullable(clazz.cast(consoleAccess()));
        case "Groups":
            return Optional.ofNullable(clazz.cast(groups()));
        case "Pending":
            return Optional.ofNullable(clazz.cast(pending()));
        case "Username":
            return Optional.ofNullable(clazz.cast(username()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserResponse, T> g) {
        return obj -> g.apply((DescribeUserResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MqResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeUserResponse> {
        /**
         * Required. The unique ID that Amazon MQ generates for the broker.
         * 
         * @param brokerId
         *        Required. The unique ID that Amazon MQ generates for the broker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder brokerId(String brokerId);

        /**
         * Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
         * 
         * @param consoleAccess
         *        Enables access to the the ActiveMQ Web Console for the ActiveMQ user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consoleAccess(Boolean consoleAccess);

        /**
         * The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric
         * characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         * 
         * @param groups
         *        The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only
         *        alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100
         *        characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<String> groups);

        /**
         * The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only alphanumeric
         * characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         * 
         * @param groups
         *        The list of groups (20 maximum) to which the ActiveMQ user belongs. This value can contain only
         *        alphanumeric characters, dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100
         *        characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(String... groups);

        /**
         * The status of the changes pending for the ActiveMQ user.
         * 
         * @param pending
         *        The status of the changes pending for the ActiveMQ user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(UserPendingChanges pending);

        /**
         * The status of the changes pending for the ActiveMQ user. This is a convenience that creates an instance of
         * the {@link UserPendingChanges.Builder} avoiding the need to create one manually via
         * {@link UserPendingChanges#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserPendingChanges.Builder#build()} is called immediately and its
         * result is passed to {@link #pending(UserPendingChanges)}.
         * 
         * @param pending
         *        a consumer that will call methods on {@link UserPendingChanges.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pending(UserPendingChanges)
         */
        default Builder pending(Consumer<UserPendingChanges.Builder> pending) {
            return pending(UserPendingChanges.builder().applyMutation(pending).build());
        }

        /**
         * Required. The username of the ActiveMQ user. This value can contain only alphanumeric characters, dashes,
         * periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         * 
         * @param username
         *        Required. The username of the ActiveMQ user. This value can contain only alphanumeric characters,
         *        dashes, periods, underscores, and tildes (- . _ ~). This value must be 2-100 characters long.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder username(String username);
    }

    static final class BuilderImpl extends MqResponse.BuilderImpl implements Builder {
        private String brokerId;

        private Boolean consoleAccess;

        private List<String> groups = DefaultSdkAutoConstructList.getInstance();

        private UserPendingChanges pending;

        private String username;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserResponse model) {
            super(model);
            brokerId(model.brokerId);
            consoleAccess(model.consoleAccess);
            groups(model.groups);
            pending(model.pending);
            username(model.username);
        }

        public final String getBrokerId() {
            return brokerId;
        }

        @Override
        public final Builder brokerId(String brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final void setBrokerId(String brokerId) {
            this.brokerId = brokerId;
        }

        public final Boolean getConsoleAccess() {
            return consoleAccess;
        }

        @Override
        public final Builder consoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
            return this;
        }

        public final void setConsoleAccess(Boolean consoleAccess) {
            this.consoleAccess = consoleAccess;
        }

        public final Collection<String> getGroups() {
            if (groups instanceof SdkAutoConstructList) {
                return null;
            }
            return groups;
        }

        @Override
        public final Builder groups(Collection<String> groups) {
            this.groups = ___listOf__stringCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(String... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<String> groups) {
            this.groups = ___listOf__stringCopier.copy(groups);
        }

        public final UserPendingChanges.Builder getPending() {
            return pending != null ? pending.toBuilder() : null;
        }

        @Override
        public final Builder pending(UserPendingChanges pending) {
            this.pending = pending;
            return this;
        }

        public final void setPending(UserPendingChanges.BuilderImpl pending) {
            this.pending = pending != null ? pending.build() : null;
        }

        public final String getUsername() {
            return username;
        }

        @Override
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        public DescribeUserResponse build() {
            return new DescribeUserResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
