/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.migrationhub.MigrationHubAsyncClient;
import software.amazon.awssdk.services.migrationhub.model.ApplicationState;
import software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesRequest;
import software.amazon.awssdk.services.migrationhub.model.ListApplicationStatesResponse;

public class ListApplicationStatesPublisher
implements SdkPublisher<ListApplicationStatesResponse> {
    private final MigrationHubAsyncClient client;
    private final ListApplicationStatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApplicationStatesPublisher(MigrationHubAsyncClient client, ListApplicationStatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApplicationStatesPublisher(MigrationHubAsyncClient client, ListApplicationStatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApplicationStatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApplicationStatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ApplicationState> applicationStateList() {
        Function<ListApplicationStatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.applicationStateList() != null) {
                return response.applicationStateList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListApplicationStatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApplicationStatesResponseFetcher
    implements AsyncPageFetcher<ListApplicationStatesResponse> {
        private ListApplicationStatesResponseFetcher() {
        }

        public boolean hasNextPage(ListApplicationStatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApplicationStatesResponse> nextPage(ListApplicationStatesResponse previousPage) {
            if (previousPage == null) {
                return ListApplicationStatesPublisher.this.client.listApplicationStates(ListApplicationStatesPublisher.this.firstRequest);
            }
            return ListApplicationStatesPublisher.this.client.listApplicationStates((ListApplicationStatesRequest)((Object)ListApplicationStatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

