/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ResourceAttributeType {
    IPV4_ADDRESS("IPV4_ADDRESS"),
    IPV6_ADDRESS("IPV6_ADDRESS"),
    MAC_ADDRESS("MAC_ADDRESS"),
    FQDN("FQDN"),
    VM_MANAGER_ID("VM_MANAGER_ID"),
    VM_MANAGED_OBJECT_REFERENCE("VM_MANAGED_OBJECT_REFERENCE"),
    VM_NAME("VM_NAME"),
    VM_PATH("VM_PATH"),
    BIOS_ID("BIOS_ID"),
    MOTHERBOARD_SERIAL_NUMBER("MOTHERBOARD_SERIAL_NUMBER"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ResourceAttributeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceAttributeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ResourceAttributeType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceAttributeType> knownValues() {
        return Stream.of(ResourceAttributeType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

