/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mediaconvert.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AudioDurationCorrection {
    DISABLED("DISABLED"),
    AUTO("AUTO"),
    TRACK("TRACK"),
    FRAME("FRAME"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AudioDurationCorrection> VALUE_MAP;
    private final String value;

    private AudioDurationCorrection(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AudioDurationCorrection fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AudioDurationCorrection> knownValues() {
        EnumSet<AudioDurationCorrection> knownValues = EnumSet.allOf(AudioDurationCorrection.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AudioDurationCorrection.class, AudioDurationCorrection::toString);
    }
}

