/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.launchwizard.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.launchwizard.LaunchWizardClient;
import software.amazon.awssdk.services.launchwizard.internal.UserAgentUtils;
import software.amazon.awssdk.services.launchwizard.model.DeploymentEventDataSummary;
import software.amazon.awssdk.services.launchwizard.model.ListDeploymentEventsRequest;
import software.amazon.awssdk.services.launchwizard.model.ListDeploymentEventsResponse;

public class ListDeploymentEventsIterable
implements SdkIterable<ListDeploymentEventsResponse> {
    private final LaunchWizardClient client;
    private final ListDeploymentEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeploymentEventsIterable(LaunchWizardClient client, ListDeploymentEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDeploymentEventsResponseFetcher();
    }

    public Iterator<ListDeploymentEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DeploymentEventDataSummary> deploymentEvents() {
        Function<ListDeploymentEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.deploymentEvents() != null) {
                return response.deploymentEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDeploymentEventsResponseFetcher
    implements SyncPageFetcher<ListDeploymentEventsResponse> {
        private ListDeploymentEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeploymentEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeploymentEventsResponse nextPage(ListDeploymentEventsResponse previousPage) {
            if (previousPage == null) {
                return ListDeploymentEventsIterable.this.client.listDeploymentEvents(ListDeploymentEventsIterable.this.firstRequest);
            }
            return ListDeploymentEventsIterable.this.client.listDeploymentEvents((ListDeploymentEventsRequest)((Object)ListDeploymentEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

