/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iot.IotClient;
import software.amazon.awssdk.services.iot.model.ListScheduledAuditsRequest;
import software.amazon.awssdk.services.iot.model.ListScheduledAuditsResponse;
import software.amazon.awssdk.services.iot.model.ScheduledAuditMetadata;

public class ListScheduledAuditsIterable
implements SdkIterable<ListScheduledAuditsResponse> {
    private final IotClient client;
    private final ListScheduledAuditsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListScheduledAuditsIterable(IotClient client, ListScheduledAuditsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListScheduledAuditsResponseFetcher();
    }

    public Iterator<ListScheduledAuditsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScheduledAuditMetadata> scheduledAudits() {
        Function<ListScheduledAuditsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scheduledAudits() != null) {
                return response.scheduledAudits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListScheduledAuditsResponseFetcher
    implements SyncPageFetcher<ListScheduledAuditsResponse> {
        private ListScheduledAuditsResponseFetcher() {
        }

        public boolean hasNextPage(ListScheduledAuditsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListScheduledAuditsResponse nextPage(ListScheduledAuditsResponse previousPage) {
            if (previousPage == null) {
                return ListScheduledAuditsIterable.this.client.listScheduledAudits(ListScheduledAuditsIterable.this.firstRequest);
            }
            return ListScheduledAuditsIterable.this.client.listScheduledAudits((ListScheduledAuditsRequest)((Object)ListScheduledAuditsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

