/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ViolationEventType {
    IN_ALARM("in-alarm"),
    ALARM_CLEARED("alarm-cleared"),
    ALARM_INVALIDATED("alarm-invalidated"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ViolationEventType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ViolationEventType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ViolationEventType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ViolationEventType> knownValues() {
        return Stream.of(ViolationEventType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

