/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iot.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iot.model.AssetPropertyTimestamp;
import software.amazon.awssdk.services.iot.model.AssetPropertyVariant;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetPropertyValue
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetPropertyValue> {
    private static final SdkField<AssetPropertyVariant> VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("value").getter(AssetPropertyValue.getter(AssetPropertyValue::value)).setter(AssetPropertyValue.setter(Builder::value)).constructor(AssetPropertyVariant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build();
    private static final SdkField<AssetPropertyTimestamp> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("timestamp").getter(AssetPropertyValue.getter(AssetPropertyValue::timestamp)).setter(AssetPropertyValue.setter(Builder::timestamp)).constructor(AssetPropertyTimestamp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()}).build();
    private static final SdkField<String> QUALITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("quality").getter(AssetPropertyValue.getter(AssetPropertyValue::quality)).setter(AssetPropertyValue.setter(Builder::quality)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quality").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VALUE_FIELD, TIMESTAMP_FIELD, QUALITY_FIELD));
    private static final long serialVersionUID = 1L;
    private final AssetPropertyVariant value;
    private final AssetPropertyTimestamp timestamp;
    private final String quality;

    private AssetPropertyValue(BuilderImpl builder) {
        this.value = builder.value;
        this.timestamp = builder.timestamp;
        this.quality = builder.quality;
    }

    public final AssetPropertyVariant value() {
        return this.value;
    }

    public final AssetPropertyTimestamp timestamp() {
        return this.timestamp;
    }

    public final String quality() {
        return this.quality;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.value());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.quality());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetPropertyValue)) {
            return false;
        }
        AssetPropertyValue other = (AssetPropertyValue)obj;
        return Objects.equals(this.value(), other.value()) && Objects.equals(this.timestamp(), other.timestamp()) && Objects.equals(this.quality(), other.quality());
    }

    public final String toString() {
        return ToString.builder((String)"AssetPropertyValue").add("Value", (Object)this.value()).add("Timestamp", (Object)this.timestamp()).add("Quality", (Object)this.quality()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "value": {
                return Optional.ofNullable(clazz.cast(this.value()));
            }
            case "timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "quality": {
                return Optional.ofNullable(clazz.cast(this.quality()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssetPropertyValue, T> g) {
        return obj -> g.apply((AssetPropertyValue)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AssetPropertyVariant value;
        private AssetPropertyTimestamp timestamp;
        private String quality;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetPropertyValue model) {
            this.value(model.value);
            this.timestamp(model.timestamp);
            this.quality(model.quality);
        }

        public final AssetPropertyVariant.Builder getValue() {
            return this.value != null ? this.value.toBuilder() : null;
        }

        @Override
        public final Builder value(AssetPropertyVariant value) {
            this.value = value;
            return this;
        }

        public final void setValue(AssetPropertyVariant.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        public final AssetPropertyTimestamp.Builder getTimestamp() {
            return this.timestamp != null ? this.timestamp.toBuilder() : null;
        }

        @Override
        public final Builder timestamp(AssetPropertyTimestamp timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(AssetPropertyTimestamp.BuilderImpl timestamp) {
            this.timestamp = timestamp != null ? timestamp.build() : null;
        }

        public final String getQuality() {
            return this.quality;
        }

        @Override
        public final Builder quality(String quality) {
            this.quality = quality;
            return this;
        }

        public final void setQuality(String quality) {
            this.quality = quality;
        }

        public AssetPropertyValue build() {
            return new AssetPropertyValue(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetPropertyValue> {
        public Builder value(AssetPropertyVariant var1);

        default public Builder value(Consumer<AssetPropertyVariant.Builder> value) {
            return this.value((AssetPropertyVariant)((AssetPropertyVariant.Builder)AssetPropertyVariant.builder().applyMutation(value)).build());
        }

        public Builder timestamp(AssetPropertyTimestamp var1);

        default public Builder timestamp(Consumer<AssetPropertyTimestamp.Builder> timestamp) {
            return this.timestamp((AssetPropertyTimestamp)((AssetPropertyTimestamp.Builder)AssetPropertyTimestamp.builder().applyMutation(timestamp)).build());
        }

        public Builder quality(String var1);
    }
}

