/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConfigurationSyncStatus {
    IN_SYNC("InSync"),
    OUT_OF_SYNC("OutOfSync"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConfigurationSyncStatus> VALUE_MAP;
    private final String value;

    private ConfigurationSyncStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigurationSyncStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigurationSyncStatus> knownValues() {
        EnumSet<ConfigurationSyncStatus> knownValues = EnumSet.allOf(ConfigurationSyncStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConfigurationSyncStatus.class, ConfigurationSyncStatus::toString);
    }
}

