/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.greengrass.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.greengrass.model.GreengrassResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateGroupCertificateConfigurationResponse
extends GreengrassResponse
implements ToCopyableBuilder<Builder, UpdateGroupCertificateConfigurationResponse> {
    private static final SdkField<String> CERTIFICATE_AUTHORITY_EXPIRY_IN_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateGroupCertificateConfigurationResponse.getter(UpdateGroupCertificateConfigurationResponse::certificateAuthorityExpiryInMilliseconds)).setter(UpdateGroupCertificateConfigurationResponse.setter(Builder::certificateAuthorityExpiryInMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityExpiryInMilliseconds").build()}).build();
    private static final SdkField<String> CERTIFICATE_EXPIRY_IN_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateGroupCertificateConfigurationResponse.getter(UpdateGroupCertificateConfigurationResponse::certificateExpiryInMilliseconds)).setter(UpdateGroupCertificateConfigurationResponse.setter(Builder::certificateExpiryInMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateExpiryInMilliseconds").build()}).build();
    private static final SdkField<String> GROUP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(UpdateGroupCertificateConfigurationResponse.getter(UpdateGroupCertificateConfigurationResponse::groupId)).setter(UpdateGroupCertificateConfigurationResponse.setter(Builder::groupId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_AUTHORITY_EXPIRY_IN_MILLISECONDS_FIELD, CERTIFICATE_EXPIRY_IN_MILLISECONDS_FIELD, GROUP_ID_FIELD));
    private final String certificateAuthorityExpiryInMilliseconds;
    private final String certificateExpiryInMilliseconds;
    private final String groupId;

    private UpdateGroupCertificateConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.certificateAuthorityExpiryInMilliseconds = builder.certificateAuthorityExpiryInMilliseconds;
        this.certificateExpiryInMilliseconds = builder.certificateExpiryInMilliseconds;
        this.groupId = builder.groupId;
    }

    public String certificateAuthorityExpiryInMilliseconds() {
        return this.certificateAuthorityExpiryInMilliseconds;
    }

    public String certificateExpiryInMilliseconds() {
        return this.certificateExpiryInMilliseconds;
    }

    public String groupId() {
        return this.groupId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateAuthorityExpiryInMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.certificateExpiryInMilliseconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGroupCertificateConfigurationResponse)) {
            return false;
        }
        UpdateGroupCertificateConfigurationResponse other = (UpdateGroupCertificateConfigurationResponse)((Object)obj);
        return Objects.equals(this.certificateAuthorityExpiryInMilliseconds(), other.certificateAuthorityExpiryInMilliseconds()) && Objects.equals(this.certificateExpiryInMilliseconds(), other.certificateExpiryInMilliseconds()) && Objects.equals(this.groupId(), other.groupId());
    }

    public String toString() {
        return ToString.builder((String)"UpdateGroupCertificateConfigurationResponse").add("CertificateAuthorityExpiryInMilliseconds", (Object)this.certificateAuthorityExpiryInMilliseconds()).add("CertificateExpiryInMilliseconds", (Object)this.certificateExpiryInMilliseconds()).add("GroupId", (Object)this.groupId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CertificateAuthorityExpiryInMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.certificateAuthorityExpiryInMilliseconds()));
            }
            case "CertificateExpiryInMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.certificateExpiryInMilliseconds()));
            }
            case "GroupId": {
                return Optional.ofNullable(clazz.cast(this.groupId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGroupCertificateConfigurationResponse, T> g) {
        return obj -> g.apply((UpdateGroupCertificateConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GreengrassResponse.BuilderImpl
    implements Builder {
        private String certificateAuthorityExpiryInMilliseconds;
        private String certificateExpiryInMilliseconds;
        private String groupId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGroupCertificateConfigurationResponse model) {
            super(model);
            this.certificateAuthorityExpiryInMilliseconds(model.certificateAuthorityExpiryInMilliseconds);
            this.certificateExpiryInMilliseconds(model.certificateExpiryInMilliseconds);
            this.groupId(model.groupId);
        }

        public final String getCertificateAuthorityExpiryInMilliseconds() {
            return this.certificateAuthorityExpiryInMilliseconds;
        }

        @Override
        public final Builder certificateAuthorityExpiryInMilliseconds(String certificateAuthorityExpiryInMilliseconds) {
            this.certificateAuthorityExpiryInMilliseconds = certificateAuthorityExpiryInMilliseconds;
            return this;
        }

        public final void setCertificateAuthorityExpiryInMilliseconds(String certificateAuthorityExpiryInMilliseconds) {
            this.certificateAuthorityExpiryInMilliseconds = certificateAuthorityExpiryInMilliseconds;
        }

        public final String getCertificateExpiryInMilliseconds() {
            return this.certificateExpiryInMilliseconds;
        }

        @Override
        public final Builder certificateExpiryInMilliseconds(String certificateExpiryInMilliseconds) {
            this.certificateExpiryInMilliseconds = certificateExpiryInMilliseconds;
            return this;
        }

        public final void setCertificateExpiryInMilliseconds(String certificateExpiryInMilliseconds) {
            this.certificateExpiryInMilliseconds = certificateExpiryInMilliseconds;
        }

        public final String getGroupId() {
            return this.groupId;
        }

        @Override
        public final Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public final void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        @Override
        public UpdateGroupCertificateConfigurationResponse build() {
            return new UpdateGroupCertificateConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GreengrassResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateGroupCertificateConfigurationResponse> {
        public Builder certificateAuthorityExpiryInMilliseconds(String var1);

        public Builder certificateExpiryInMilliseconds(String var1);

        public Builder groupId(String var1);
    }
}

