/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.firehose.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DefaultDocumentIdFormat {
    FIREHOSE_DEFAULT("FIREHOSE_DEFAULT"),
    NO_DOCUMENT_ID("NO_DOCUMENT_ID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DefaultDocumentIdFormat> VALUE_MAP;
    private final String value;

    private DefaultDocumentIdFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DefaultDocumentIdFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DefaultDocumentIdFormat> knownValues() {
        EnumSet<DefaultDocumentIdFormat> knownValues = EnumSet.allOf(DefaultDocumentIdFormat.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DefaultDocumentIdFormat.class, DefaultDocumentIdFormat::toString);
    }
}

