/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeStatusResponse;
import software.amazon.awssdk.services.ec2.model.VolumeStatusItem;

public class DescribeVolumeStatusPublisher
implements SdkPublisher<DescribeVolumeStatusResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVolumeStatusRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVolumeStatusPublisher(Ec2AsyncClient client, DescribeVolumeStatusRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVolumeStatusPublisher(Ec2AsyncClient client, DescribeVolumeStatusRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVolumeStatusResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVolumeStatusResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<VolumeStatusItem> volumeStatuses() {
        Function<DescribeVolumeStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.volumeStatuses() != null) {
                return response.volumeStatuses().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeVolumeStatusResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeVolumeStatusResponseFetcher
    implements AsyncPageFetcher<DescribeVolumeStatusResponse> {
        private DescribeVolumeStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVolumeStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVolumeStatusResponse> nextPage(DescribeVolumeStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeVolumeStatusPublisher.this.client.describeVolumeStatus(DescribeVolumeStatusPublisher.this.firstRequest);
            }
            return DescribeVolumeStatusPublisher.this.client.describeVolumeStatus((DescribeVolumeStatusRequest)((Object)DescribeVolumeStatusPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

