/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse;
import software.amazon.awssdk.services.ec2.model.Subnet;

public class DescribeSubnetsIterable
implements SdkIterable<DescribeSubnetsResponse> {
    private final Ec2Client client;
    private final DescribeSubnetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeSubnetsIterable(Ec2Client client, DescribeSubnetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeSubnetsResponseFetcher();
    }

    public Iterator<DescribeSubnetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Subnet> subnets() {
        Function<DescribeSubnetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subnets() != null) {
                return response.subnets().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeSubnetsResponseFetcher
    implements SyncPageFetcher<DescribeSubnetsResponse> {
        private DescribeSubnetsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSubnetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeSubnetsResponse nextPage(DescribeSubnetsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSubnetsIterable.this.client.describeSubnets(DescribeSubnetsIterable.this.firstRequest);
            }
            return DescribeSubnetsIterable.this.client.describeSubnets((DescribeSubnetsRequest)((Object)DescribeSubnetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

