/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeFastLaunchImagesSuccessItem;

public class DescribeFastLaunchImagesIterable
implements SdkIterable<DescribeFastLaunchImagesResponse> {
    private final Ec2Client client;
    private final DescribeFastLaunchImagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeFastLaunchImagesIterable(Ec2Client client, DescribeFastLaunchImagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeFastLaunchImagesResponseFetcher();
    }

    public Iterator<DescribeFastLaunchImagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DescribeFastLaunchImagesSuccessItem> fastLaunchImages() {
        Function<DescribeFastLaunchImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.fastLaunchImages() != null) {
                return response.fastLaunchImages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeFastLaunchImagesResponseFetcher
    implements SyncPageFetcher<DescribeFastLaunchImagesResponse> {
        private DescribeFastLaunchImagesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeFastLaunchImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeFastLaunchImagesResponse nextPage(DescribeFastLaunchImagesResponse previousPage) {
            if (previousPage == null) {
                return DescribeFastLaunchImagesIterable.this.client.describeFastLaunchImages(DescribeFastLaunchImagesIterable.this.firstRequest);
            }
            return DescribeFastLaunchImagesIterable.this.client.describeFastLaunchImages((DescribeFastLaunchImagesRequest)((Object)DescribeFastLaunchImagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

