/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ReplaceRootVolumeTaskState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ReplaceRootVolumeTask
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ReplaceRootVolumeTask> {
    private static final SdkField<String> REPLACE_ROOT_VOLUME_TASK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReplaceRootVolumeTaskId").getter(ReplaceRootVolumeTask.getter(ReplaceRootVolumeTask::replaceRootVolumeTaskId)).setter(ReplaceRootVolumeTask.setter(Builder::replaceRootVolumeTaskId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplaceRootVolumeTaskId").unmarshallLocationName("replaceRootVolumeTaskId").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(ReplaceRootVolumeTask.getter(ReplaceRootVolumeTask::instanceId)).setter(ReplaceRootVolumeTask.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> TASK_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TaskState").getter(ReplaceRootVolumeTask.getter(ReplaceRootVolumeTask::taskStateAsString)).setter(ReplaceRootVolumeTask.setter(Builder::taskState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskState").unmarshallLocationName("taskState").build()}).build();
    private static final SdkField<String> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StartTime").getter(ReplaceRootVolumeTask.getter(ReplaceRootVolumeTask::startTime)).setter(ReplaceRootVolumeTask.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").unmarshallLocationName("startTime").build()}).build();
    private static final SdkField<String> COMPLETE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompleteTime").getter(ReplaceRootVolumeTask.getter(ReplaceRootVolumeTask::completeTime)).setter(ReplaceRootVolumeTask.setter(Builder::completeTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompleteTime").unmarshallLocationName("completeTime").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(ReplaceRootVolumeTask.getter(ReplaceRootVolumeTask::tags)).setter(ReplaceRootVolumeTask.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPLACE_ROOT_VOLUME_TASK_ID_FIELD, INSTANCE_ID_FIELD, TASK_STATE_FIELD, START_TIME_FIELD, COMPLETE_TIME_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String replaceRootVolumeTaskId;
    private final String instanceId;
    private final String taskState;
    private final String startTime;
    private final String completeTime;
    private final List<Tag> tags;

    private ReplaceRootVolumeTask(BuilderImpl builder) {
        this.replaceRootVolumeTaskId = builder.replaceRootVolumeTaskId;
        this.instanceId = builder.instanceId;
        this.taskState = builder.taskState;
        this.startTime = builder.startTime;
        this.completeTime = builder.completeTime;
        this.tags = builder.tags;
    }

    public final String replaceRootVolumeTaskId() {
        return this.replaceRootVolumeTaskId;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final ReplaceRootVolumeTaskState taskState() {
        return ReplaceRootVolumeTaskState.fromValue(this.taskState);
    }

    public final String taskStateAsString() {
        return this.taskState;
    }

    public final String startTime() {
        return this.startTime;
    }

    public final String completeTime() {
        return this.completeTime;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.replaceRootVolumeTaskId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.taskStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.completeTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplaceRootVolumeTask)) {
            return false;
        }
        ReplaceRootVolumeTask other = (ReplaceRootVolumeTask)obj;
        return Objects.equals(this.replaceRootVolumeTaskId(), other.replaceRootVolumeTaskId()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.taskStateAsString(), other.taskStateAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.completeTime(), other.completeTime()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"ReplaceRootVolumeTask").add("ReplaceRootVolumeTaskId", (Object)this.replaceRootVolumeTaskId()).add("InstanceId", (Object)this.instanceId()).add("TaskState", (Object)this.taskStateAsString()).add("StartTime", (Object)this.startTime()).add("CompleteTime", (Object)this.completeTime()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReplaceRootVolumeTaskId": {
                return Optional.ofNullable(clazz.cast(this.replaceRootVolumeTaskId()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "TaskState": {
                return Optional.ofNullable(clazz.cast(this.taskStateAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "CompleteTime": {
                return Optional.ofNullable(clazz.cast(this.completeTime()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReplaceRootVolumeTask, T> g) {
        return obj -> g.apply((ReplaceRootVolumeTask)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String replaceRootVolumeTaskId;
        private String instanceId;
        private String taskState;
        private String startTime;
        private String completeTime;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ReplaceRootVolumeTask model) {
            this.replaceRootVolumeTaskId(model.replaceRootVolumeTaskId);
            this.instanceId(model.instanceId);
            this.taskState(model.taskState);
            this.startTime(model.startTime);
            this.completeTime(model.completeTime);
            this.tags(model.tags);
        }

        public final String getReplaceRootVolumeTaskId() {
            return this.replaceRootVolumeTaskId;
        }

        public final void setReplaceRootVolumeTaskId(String replaceRootVolumeTaskId) {
            this.replaceRootVolumeTaskId = replaceRootVolumeTaskId;
        }

        @Override
        @Transient
        public final Builder replaceRootVolumeTaskId(String replaceRootVolumeTaskId) {
            this.replaceRootVolumeTaskId = replaceRootVolumeTaskId;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getTaskState() {
            return this.taskState;
        }

        public final void setTaskState(String taskState) {
            this.taskState = taskState;
        }

        @Override
        @Transient
        public final Builder taskState(String taskState) {
            this.taskState = taskState;
            return this;
        }

        @Override
        @Transient
        public final Builder taskState(ReplaceRootVolumeTaskState taskState) {
            this.taskState(taskState == null ? null : taskState.toString());
            return this;
        }

        public final String getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(String startTime) {
            this.startTime = startTime;
        }

        @Override
        @Transient
        public final Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getCompleteTime() {
            return this.completeTime;
        }

        public final void setCompleteTime(String completeTime) {
            this.completeTime = completeTime;
        }

        @Override
        @Transient
        public final Builder completeTime(String completeTime) {
            this.completeTime = completeTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ReplaceRootVolumeTask build() {
            return new ReplaceRootVolumeTask(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ReplaceRootVolumeTask> {
        public Builder replaceRootVolumeTaskId(String var1);

        public Builder instanceId(String var1);

        public Builder taskState(String var1);

        public Builder taskState(ReplaceRootVolumeTaskState var1);

        public Builder startTime(String var1);

        public Builder completeTime(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

