/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ArchitectureType;
import software.amazon.awssdk.services.ec2.model.ArchitectureTypeSetCopier;
import software.amazon.awssdk.services.ec2.model.InstanceRequirementsRequest;
import software.amazon.awssdk.services.ec2.model.VirtualizationType;
import software.amazon.awssdk.services.ec2.model.VirtualizationTypeSetCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceRequirementsWithMetadataRequest
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceRequirementsWithMetadataRequest> {
    private static final SdkField<List<String>> ARCHITECTURE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ArchitectureTypes").getter(InstanceRequirementsWithMetadataRequest.getter(InstanceRequirementsWithMetadataRequest::architectureTypesAsStrings)).setter(InstanceRequirementsWithMetadataRequest.setter(Builder::architectureTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchitectureType").unmarshallLocationName("ArchitectureType").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VIRTUALIZATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VirtualizationTypes").getter(InstanceRequirementsWithMetadataRequest.getter(InstanceRequirementsWithMetadataRequest::virtualizationTypesAsStrings)).setter(InstanceRequirementsWithMetadataRequest.setter(Builder::virtualizationTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualizationType").unmarshallLocationName("VirtualizationType").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<InstanceRequirementsRequest> INSTANCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InstanceRequirements").getter(InstanceRequirementsWithMetadataRequest.getter(InstanceRequirementsWithMetadataRequest::instanceRequirements)).setter(InstanceRequirementsWithMetadataRequest.setter(Builder::instanceRequirements)).constructor(InstanceRequirementsRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceRequirements").unmarshallLocationName("InstanceRequirements").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHITECTURE_TYPES_FIELD, VIRTUALIZATION_TYPES_FIELD, INSTANCE_REQUIREMENTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> architectureTypes;
    private final List<String> virtualizationTypes;
    private final InstanceRequirementsRequest instanceRequirements;

    private InstanceRequirementsWithMetadataRequest(BuilderImpl builder) {
        this.architectureTypes = builder.architectureTypes;
        this.virtualizationTypes = builder.virtualizationTypes;
        this.instanceRequirements = builder.instanceRequirements;
    }

    public final List<ArchitectureType> architectureTypes() {
        return ArchitectureTypeSetCopier.copyStringToEnum(this.architectureTypes);
    }

    public final boolean hasArchitectureTypes() {
        return this.architectureTypes != null && !(this.architectureTypes instanceof SdkAutoConstructList);
    }

    public final List<String> architectureTypesAsStrings() {
        return this.architectureTypes;
    }

    public final List<VirtualizationType> virtualizationTypes() {
        return VirtualizationTypeSetCopier.copyStringToEnum(this.virtualizationTypes);
    }

    public final boolean hasVirtualizationTypes() {
        return this.virtualizationTypes != null && !(this.virtualizationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> virtualizationTypesAsStrings() {
        return this.virtualizationTypes;
    }

    public final InstanceRequirementsRequest instanceRequirements() {
        return this.instanceRequirements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArchitectureTypes() ? this.architectureTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVirtualizationTypes() ? this.virtualizationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceRequirements());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceRequirementsWithMetadataRequest)) {
            return false;
        }
        InstanceRequirementsWithMetadataRequest other = (InstanceRequirementsWithMetadataRequest)obj;
        return this.hasArchitectureTypes() == other.hasArchitectureTypes() && Objects.equals(this.architectureTypesAsStrings(), other.architectureTypesAsStrings()) && this.hasVirtualizationTypes() == other.hasVirtualizationTypes() && Objects.equals(this.virtualizationTypesAsStrings(), other.virtualizationTypesAsStrings()) && Objects.equals(this.instanceRequirements(), other.instanceRequirements());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceRequirementsWithMetadataRequest").add("ArchitectureTypes", this.hasArchitectureTypes() ? this.architectureTypesAsStrings() : null).add("VirtualizationTypes", this.hasVirtualizationTypes() ? this.virtualizationTypesAsStrings() : null).add("InstanceRequirements", (Object)this.instanceRequirements()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArchitectureTypes": {
                return Optional.ofNullable(clazz.cast(this.architectureTypesAsStrings()));
            }
            case "VirtualizationTypes": {
                return Optional.ofNullable(clazz.cast(this.virtualizationTypesAsStrings()));
            }
            case "InstanceRequirements": {
                return Optional.ofNullable(clazz.cast(this.instanceRequirements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InstanceRequirementsWithMetadataRequest, T> g) {
        return obj -> g.apply((InstanceRequirementsWithMetadataRequest)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> architectureTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> virtualizationTypes = DefaultSdkAutoConstructList.getInstance();
        private InstanceRequirementsRequest instanceRequirements;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceRequirementsWithMetadataRequest model) {
            this.architectureTypesWithStrings(model.architectureTypes);
            this.virtualizationTypesWithStrings(model.virtualizationTypes);
            this.instanceRequirements(model.instanceRequirements);
        }

        public final Collection<String> getArchitectureTypes() {
            if (this.architectureTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.architectureTypes;
        }

        public final void setArchitectureTypes(Collection<String> architectureTypes) {
            this.architectureTypes = ArchitectureTypeSetCopier.copy(architectureTypes);
        }

        @Override
        @Transient
        public final Builder architectureTypesWithStrings(Collection<String> architectureTypes) {
            this.architectureTypes = ArchitectureTypeSetCopier.copy(architectureTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder architectureTypesWithStrings(String ... architectureTypes) {
            this.architectureTypesWithStrings(Arrays.asList(architectureTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder architectureTypes(Collection<ArchitectureType> architectureTypes) {
            this.architectureTypes = ArchitectureTypeSetCopier.copyEnumToString(architectureTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder architectureTypes(ArchitectureType ... architectureTypes) {
            this.architectureTypes(Arrays.asList(architectureTypes));
            return this;
        }

        public final Collection<String> getVirtualizationTypes() {
            if (this.virtualizationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.virtualizationTypes;
        }

        public final void setVirtualizationTypes(Collection<String> virtualizationTypes) {
            this.virtualizationTypes = VirtualizationTypeSetCopier.copy(virtualizationTypes);
        }

        @Override
        @Transient
        public final Builder virtualizationTypesWithStrings(Collection<String> virtualizationTypes) {
            this.virtualizationTypes = VirtualizationTypeSetCopier.copy(virtualizationTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder virtualizationTypesWithStrings(String ... virtualizationTypes) {
            this.virtualizationTypesWithStrings(Arrays.asList(virtualizationTypes));
            return this;
        }

        @Override
        @Transient
        public final Builder virtualizationTypes(Collection<VirtualizationType> virtualizationTypes) {
            this.virtualizationTypes = VirtualizationTypeSetCopier.copyEnumToString(virtualizationTypes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder virtualizationTypes(VirtualizationType ... virtualizationTypes) {
            this.virtualizationTypes(Arrays.asList(virtualizationTypes));
            return this;
        }

        public final InstanceRequirementsRequest.Builder getInstanceRequirements() {
            return this.instanceRequirements != null ? this.instanceRequirements.toBuilder() : null;
        }

        public final void setInstanceRequirements(InstanceRequirementsRequest.BuilderImpl instanceRequirements) {
            this.instanceRequirements = instanceRequirements != null ? instanceRequirements.build() : null;
        }

        @Override
        @Transient
        public final Builder instanceRequirements(InstanceRequirementsRequest instanceRequirements) {
            this.instanceRequirements = instanceRequirements;
            return this;
        }

        public InstanceRequirementsWithMetadataRequest build() {
            return new InstanceRequirementsWithMetadataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceRequirementsWithMetadataRequest> {
        public Builder architectureTypesWithStrings(Collection<String> var1);

        public Builder architectureTypesWithStrings(String ... var1);

        public Builder architectureTypes(Collection<ArchitectureType> var1);

        public Builder architectureTypes(ArchitectureType ... var1);

        public Builder virtualizationTypesWithStrings(Collection<String> var1);

        public Builder virtualizationTypesWithStrings(String ... var1);

        public Builder virtualizationTypes(Collection<VirtualizationType> var1);

        public Builder virtualizationTypes(VirtualizationType ... var1);

        public Builder instanceRequirements(InstanceRequirementsRequest var1);

        default public Builder instanceRequirements(Consumer<InstanceRequirementsRequest.Builder> instanceRequirements) {
            return this.instanceRequirements((InstanceRequirementsRequest)((InstanceRequirementsRequest.Builder)InstanceRequirementsRequest.builder().applyMutation(instanceRequirements)).build());
        }
    }
}

