/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.FastLaunchLaunchTemplateSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.FastLaunchSnapshotConfigurationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnableFastLaunchRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, EnableFastLaunchRequest> {
    private static final SdkField<String> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageId").getter(EnableFastLaunchRequest.getter(EnableFastLaunchRequest::imageId)).setter(EnableFastLaunchRequest.setter(Builder::imageId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageId").unmarshallLocationName("ImageId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(EnableFastLaunchRequest.getter(EnableFastLaunchRequest::resourceType)).setter(EnableFastLaunchRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").unmarshallLocationName("ResourceType").build()}).build();
    private static final SdkField<FastLaunchSnapshotConfigurationRequest> SNAPSHOT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SnapshotConfiguration").getter(EnableFastLaunchRequest.getter(EnableFastLaunchRequest::snapshotConfiguration)).setter(EnableFastLaunchRequest.setter(Builder::snapshotConfiguration)).constructor(FastLaunchSnapshotConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotConfiguration").unmarshallLocationName("SnapshotConfiguration").build()}).build();
    private static final SdkField<FastLaunchLaunchTemplateSpecificationRequest> LAUNCH_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LaunchTemplate").getter(EnableFastLaunchRequest.getter(EnableFastLaunchRequest::launchTemplate)).setter(EnableFastLaunchRequest.setter(Builder::launchTemplate)).constructor(FastLaunchLaunchTemplateSpecificationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchTemplate").unmarshallLocationName("LaunchTemplate").build()}).build();
    private static final SdkField<Integer> MAX_PARALLEL_LAUNCHES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxParallelLaunches").getter(EnableFastLaunchRequest.getter(EnableFastLaunchRequest::maxParallelLaunches)).setter(EnableFastLaunchRequest.setter(Builder::maxParallelLaunches)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxParallelLaunches").unmarshallLocationName("MaxParallelLaunches").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_ID_FIELD, RESOURCE_TYPE_FIELD, SNAPSHOT_CONFIGURATION_FIELD, LAUNCH_TEMPLATE_FIELD, MAX_PARALLEL_LAUNCHES_FIELD));
    private final String imageId;
    private final String resourceType;
    private final FastLaunchSnapshotConfigurationRequest snapshotConfiguration;
    private final FastLaunchLaunchTemplateSpecificationRequest launchTemplate;
    private final Integer maxParallelLaunches;

    private EnableFastLaunchRequest(BuilderImpl builder) {
        super(builder);
        this.imageId = builder.imageId;
        this.resourceType = builder.resourceType;
        this.snapshotConfiguration = builder.snapshotConfiguration;
        this.launchTemplate = builder.launchTemplate;
        this.maxParallelLaunches = builder.maxParallelLaunches;
    }

    public final String imageId() {
        return this.imageId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final FastLaunchSnapshotConfigurationRequest snapshotConfiguration() {
        return this.snapshotConfiguration;
    }

    public final FastLaunchLaunchTemplateSpecificationRequest launchTemplate() {
        return this.launchTemplate;
    }

    public final Integer maxParallelLaunches() {
        return this.maxParallelLaunches;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxParallelLaunches());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableFastLaunchRequest)) {
            return false;
        }
        EnableFastLaunchRequest other = (EnableFastLaunchRequest)((Object)obj);
        return Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.snapshotConfiguration(), other.snapshotConfiguration()) && Objects.equals(this.launchTemplate(), other.launchTemplate()) && Objects.equals(this.maxParallelLaunches(), other.maxParallelLaunches());
    }

    public final String toString() {
        return ToString.builder((String)"EnableFastLaunchRequest").add("ImageId", (Object)this.imageId()).add("ResourceType", (Object)this.resourceType()).add("SnapshotConfiguration", (Object)this.snapshotConfiguration()).add("LaunchTemplate", (Object)this.launchTemplate()).add("MaxParallelLaunches", (Object)this.maxParallelLaunches()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "SnapshotConfiguration": {
                return Optional.ofNullable(clazz.cast(this.snapshotConfiguration()));
            }
            case "LaunchTemplate": {
                return Optional.ofNullable(clazz.cast(this.launchTemplate()));
            }
            case "MaxParallelLaunches": {
                return Optional.ofNullable(clazz.cast(this.maxParallelLaunches()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnableFastLaunchRequest, T> g) {
        return obj -> g.apply((EnableFastLaunchRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String imageId;
        private String resourceType;
        private FastLaunchSnapshotConfigurationRequest snapshotConfiguration;
        private FastLaunchLaunchTemplateSpecificationRequest launchTemplate;
        private Integer maxParallelLaunches;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableFastLaunchRequest model) {
            super(model);
            this.imageId(model.imageId);
            this.resourceType(model.resourceType);
            this.snapshotConfiguration(model.snapshotConfiguration);
            this.launchTemplate(model.launchTemplate);
            this.maxParallelLaunches(model.maxParallelLaunches);
        }

        public final String getImageId() {
            return this.imageId;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        @Override
        @Transient
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        @Transient
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final FastLaunchSnapshotConfigurationRequest.Builder getSnapshotConfiguration() {
            return this.snapshotConfiguration != null ? this.snapshotConfiguration.toBuilder() : null;
        }

        public final void setSnapshotConfiguration(FastLaunchSnapshotConfigurationRequest.BuilderImpl snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration != null ? snapshotConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder snapshotConfiguration(FastLaunchSnapshotConfigurationRequest snapshotConfiguration) {
            this.snapshotConfiguration = snapshotConfiguration;
            return this;
        }

        public final FastLaunchLaunchTemplateSpecificationRequest.Builder getLaunchTemplate() {
            return this.launchTemplate != null ? this.launchTemplate.toBuilder() : null;
        }

        public final void setLaunchTemplate(FastLaunchLaunchTemplateSpecificationRequest.BuilderImpl launchTemplate) {
            this.launchTemplate = launchTemplate != null ? launchTemplate.build() : null;
        }

        @Override
        @Transient
        public final Builder launchTemplate(FastLaunchLaunchTemplateSpecificationRequest launchTemplate) {
            this.launchTemplate = launchTemplate;
            return this;
        }

        public final Integer getMaxParallelLaunches() {
            return this.maxParallelLaunches;
        }

        public final void setMaxParallelLaunches(Integer maxParallelLaunches) {
            this.maxParallelLaunches = maxParallelLaunches;
        }

        @Override
        @Transient
        public final Builder maxParallelLaunches(Integer maxParallelLaunches) {
            this.maxParallelLaunches = maxParallelLaunches;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EnableFastLaunchRequest build() {
            return new EnableFastLaunchRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EnableFastLaunchRequest> {
        public Builder imageId(String var1);

        public Builder resourceType(String var1);

        public Builder snapshotConfiguration(FastLaunchSnapshotConfigurationRequest var1);

        default public Builder snapshotConfiguration(Consumer<FastLaunchSnapshotConfigurationRequest.Builder> snapshotConfiguration) {
            return this.snapshotConfiguration((FastLaunchSnapshotConfigurationRequest)((FastLaunchSnapshotConfigurationRequest.Builder)FastLaunchSnapshotConfigurationRequest.builder().applyMutation(snapshotConfiguration)).build());
        }

        public Builder launchTemplate(FastLaunchLaunchTemplateSpecificationRequest var1);

        default public Builder launchTemplate(Consumer<FastLaunchLaunchTemplateSpecificationRequest.Builder> launchTemplate) {
            return this.launchTemplate((FastLaunchLaunchTemplateSpecificationRequest)((FastLaunchLaunchTemplateSpecificationRequest.Builder)FastLaunchLaunchTemplateSpecificationRequest.builder().applyMutation(launchTemplate)).build());
        }

        public Builder maxParallelLaunches(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

