/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.FilterListCopier;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.OfferingClassType;
import software.amazon.awssdk.services.ec2.model.OfferingTypeValues;
import software.amazon.awssdk.services.ec2.model.RIProductDescription;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesOfferingIdStringListCopier;
import software.amazon.awssdk.services.ec2.model.Tenancy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeReservedInstancesOfferingsRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, DescribeReservedInstancesOfferingsRequest> {
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(DescribeReservedInstancesOfferingsRequest.getter(DescribeReservedInstancesOfferingsRequest::availabilityZone)).setter(DescribeReservedInstancesOfferingsRequest.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").unmarshallLocationName("AvailabilityZone").build()}).build();
    private static final SdkField<List<Filter>> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Filters").getter(DescribeReservedInstancesOfferingsRequest.getter(DescribeReservedInstancesOfferingsRequest::filters)).setter(DescribeReservedInstancesOfferingsRequest.setter(Builder::filters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build(), ListTrait.builder().memberLocationName("Filter").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Filter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").unmarshallLocationName("Filter").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INCLUDE_MARKETPLACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IncludeMarketplace").getter(DescribeReservedInstancesOfferingsRequest.getter(DescribeReservedInstancesOfferingsRequest::includeMarketplace)).setter(DescribeReservedInstancesOfferingsRequest.setter(Builder::includeMarketplace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IncludeMarketplace").unmarshallLocationName("IncludeMarketplace").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(DescribeReservedInstancesOfferingsRequest.getter(DescribeReservedInstancesOfferingsRequest::instanceTypeAsString)).setter(DescribeReservedInstancesOfferingsRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").unmarshallLocationName("InstanceType").build()}).build();
    private static final SdkField<Long> MAX_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MaxDuration").getter(DescribeReservedInstancesOfferingsRequest.getter(DescribeReservedInstancesOfferingsRequest::maxDuration)).setter(DescribeReservedInstancesOfferingsRequest.setter(Builder::maxDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxDuration").unmarshallLocationName("MaxDuration").build()}).build();
    private static final SdkField<Integer> MAX_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxInstanceCount").getter(DescribeReservedInstancesOfferingsRequest.getter(DescribeReservedInstancesOfferingsRequest::maxInstanceCount)).setter(DescribeReservedInstancesOfferingsRequest.setter(Builder::maxInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInstanceCount").unmarshallLocationName("MaxInstanceCount").build()}).build();
    private static final SdkField<Long> MIN_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MinDuration").getter(DescribeReservedInstancesOfferingsRequest.getter(DescribeReservedInstancesOfferingsRequest::minDuration)).setter(DescribeReservedInstancesOfferingsRequest.setter(Builder::minDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinDuration").unmarshallLocationName("MinDuration").build()}).build();
    private static final SdkField<String> OFFERING_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingClass").getter(DescribeReservedInstancesOfferingsRequest.getter(DescribeReservedInstancesOfferingsRequest::offeringClassAsString)).setter(DescribeReservedInstancesOfferingsRequest.setter(Builder::offeringClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingClass").unmarshallLocationName("OfferingClass").build()}).build();
    private static final SdkField<String> PRODUCT_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductDescription").getter(DescribeReservedInstancesOfferingsRequest.getter(DescribeReservedInstancesOfferingsRequest::productDescriptionAsString)).setter(DescribeReservedInstancesOfferingsRequest.setter(Builder::productDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductDescription").unmarshallLocationName("ProductDescription").build()}).build();
    private static final SdkField<List<String>> RESERVED_INSTANCES_OFFERING_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ReservedInstancesOfferingIds").getter(DescribeReservedInstancesOfferingsRequest.getter(DescribeReservedInstancesOfferingsRequest::reservedInstancesOfferingIds)).setter(DescribeReservedInstancesOfferingsRequest.setter(Builder::reservedInstancesOfferingIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedInstancesOfferingId").unmarshallLocationName("ReservedInstancesOfferingId").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").unmarshallLocationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> INSTANCE_TENANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceTenancy").getter(DescribeReservedInstancesOfferingsRequest.getter(DescribeReservedInstancesOfferingsRequest::instanceTenancyAsString)).setter(DescribeReservedInstancesOfferingsRequest.setter(Builder::instanceTenancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTenancy").unmarshallLocationName("instanceTenancy").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DescribeReservedInstancesOfferingsRequest.getter(DescribeReservedInstancesOfferingsRequest::maxResults)).setter(DescribeReservedInstancesOfferingsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").unmarshallLocationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeReservedInstancesOfferingsRequest.getter(DescribeReservedInstancesOfferingsRequest::nextToken)).setter(DescribeReservedInstancesOfferingsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final SdkField<String> OFFERING_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OfferingType").getter(DescribeReservedInstancesOfferingsRequest.getter(DescribeReservedInstancesOfferingsRequest::offeringTypeAsString)).setter(DescribeReservedInstancesOfferingsRequest.setter(Builder::offeringType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OfferingType").unmarshallLocationName("offeringType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AVAILABILITY_ZONE_FIELD, FILTERS_FIELD, INCLUDE_MARKETPLACE_FIELD, INSTANCE_TYPE_FIELD, MAX_DURATION_FIELD, MAX_INSTANCE_COUNT_FIELD, MIN_DURATION_FIELD, OFFERING_CLASS_FIELD, PRODUCT_DESCRIPTION_FIELD, RESERVED_INSTANCES_OFFERING_IDS_FIELD, INSTANCE_TENANCY_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, OFFERING_TYPE_FIELD));
    private final String availabilityZone;
    private final List<Filter> filters;
    private final Boolean includeMarketplace;
    private final String instanceType;
    private final Long maxDuration;
    private final Integer maxInstanceCount;
    private final Long minDuration;
    private final String offeringClass;
    private final String productDescription;
    private final List<String> reservedInstancesOfferingIds;
    private final String instanceTenancy;
    private final Integer maxResults;
    private final String nextToken;
    private final String offeringType;

    private DescribeReservedInstancesOfferingsRequest(BuilderImpl builder) {
        super(builder);
        this.availabilityZone = builder.availabilityZone;
        this.filters = builder.filters;
        this.includeMarketplace = builder.includeMarketplace;
        this.instanceType = builder.instanceType;
        this.maxDuration = builder.maxDuration;
        this.maxInstanceCount = builder.maxInstanceCount;
        this.minDuration = builder.minDuration;
        this.offeringClass = builder.offeringClass;
        this.productDescription = builder.productDescription;
        this.reservedInstancesOfferingIds = builder.reservedInstancesOfferingIds;
        this.instanceTenancy = builder.instanceTenancy;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.offeringType = builder.offeringType;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final boolean hasFilters() {
        return this.filters != null && !(this.filters instanceof SdkAutoConstructList);
    }

    public final List<Filter> filters() {
        return this.filters;
    }

    public final Boolean includeMarketplace() {
        return this.includeMarketplace;
    }

    public final InstanceType instanceType() {
        return InstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final Long maxDuration() {
        return this.maxDuration;
    }

    public final Integer maxInstanceCount() {
        return this.maxInstanceCount;
    }

    public final Long minDuration() {
        return this.minDuration;
    }

    public final OfferingClassType offeringClass() {
        return OfferingClassType.fromValue(this.offeringClass);
    }

    public final String offeringClassAsString() {
        return this.offeringClass;
    }

    public final RIProductDescription productDescription() {
        return RIProductDescription.fromValue(this.productDescription);
    }

    public final String productDescriptionAsString() {
        return this.productDescription;
    }

    public final boolean hasReservedInstancesOfferingIds() {
        return this.reservedInstancesOfferingIds != null && !(this.reservedInstancesOfferingIds instanceof SdkAutoConstructList);
    }

    public final List<String> reservedInstancesOfferingIds() {
        return this.reservedInstancesOfferingIds;
    }

    public final Tenancy instanceTenancy() {
        return Tenancy.fromValue(this.instanceTenancy);
    }

    public final String instanceTenancyAsString() {
        return this.instanceTenancy;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final OfferingTypeValues offeringType() {
        return OfferingTypeValues.fromValue(this.offeringType);
    }

    public final String offeringTypeAsString() {
        return this.offeringType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilters() ? this.filters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.includeMarketplace());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.minDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.productDescriptionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReservedInstancesOfferingIds() ? this.reservedInstancesOfferingIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTenancyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.offeringTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedInstancesOfferingsRequest)) {
            return false;
        }
        DescribeReservedInstancesOfferingsRequest other = (DescribeReservedInstancesOfferingsRequest)((Object)obj);
        return Objects.equals(this.availabilityZone(), other.availabilityZone()) && this.hasFilters() == other.hasFilters() && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.includeMarketplace(), other.includeMarketplace()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.maxDuration(), other.maxDuration()) && Objects.equals(this.maxInstanceCount(), other.maxInstanceCount()) && Objects.equals(this.minDuration(), other.minDuration()) && Objects.equals(this.offeringClassAsString(), other.offeringClassAsString()) && Objects.equals(this.productDescriptionAsString(), other.productDescriptionAsString()) && this.hasReservedInstancesOfferingIds() == other.hasReservedInstancesOfferingIds() && Objects.equals(this.reservedInstancesOfferingIds(), other.reservedInstancesOfferingIds()) && Objects.equals(this.instanceTenancyAsString(), other.instanceTenancyAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.offeringTypeAsString(), other.offeringTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeReservedInstancesOfferingsRequest").add("AvailabilityZone", (Object)this.availabilityZone()).add("Filters", this.hasFilters() ? this.filters() : null).add("IncludeMarketplace", (Object)this.includeMarketplace()).add("InstanceType", (Object)this.instanceTypeAsString()).add("MaxDuration", (Object)this.maxDuration()).add("MaxInstanceCount", (Object)this.maxInstanceCount()).add("MinDuration", (Object)this.minDuration()).add("OfferingClass", (Object)this.offeringClassAsString()).add("ProductDescription", (Object)this.productDescriptionAsString()).add("ReservedInstancesOfferingIds", this.hasReservedInstancesOfferingIds() ? this.reservedInstancesOfferingIds() : null).add("InstanceTenancy", (Object)this.instanceTenancyAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("OfferingType", (Object)this.offeringTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "IncludeMarketplace": {
                return Optional.ofNullable(clazz.cast(this.includeMarketplace()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "MaxDuration": {
                return Optional.ofNullable(clazz.cast(this.maxDuration()));
            }
            case "MaxInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.maxInstanceCount()));
            }
            case "MinDuration": {
                return Optional.ofNullable(clazz.cast(this.minDuration()));
            }
            case "OfferingClass": {
                return Optional.ofNullable(clazz.cast(this.offeringClassAsString()));
            }
            case "ProductDescription": {
                return Optional.ofNullable(clazz.cast(this.productDescriptionAsString()));
            }
            case "ReservedInstancesOfferingIds": {
                return Optional.ofNullable(clazz.cast(this.reservedInstancesOfferingIds()));
            }
            case "InstanceTenancy": {
                return Optional.ofNullable(clazz.cast(this.instanceTenancyAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "OfferingType": {
                return Optional.ofNullable(clazz.cast(this.offeringTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedInstancesOfferingsRequest, T> g) {
        return obj -> g.apply((DescribeReservedInstancesOfferingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String availabilityZone;
        private List<Filter> filters = DefaultSdkAutoConstructList.getInstance();
        private Boolean includeMarketplace;
        private String instanceType;
        private Long maxDuration;
        private Integer maxInstanceCount;
        private Long minDuration;
        private String offeringClass;
        private String productDescription;
        private List<String> reservedInstancesOfferingIds = DefaultSdkAutoConstructList.getInstance();
        private String instanceTenancy;
        private Integer maxResults;
        private String nextToken;
        private String offeringType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedInstancesOfferingsRequest model) {
            super(model);
            this.availabilityZone(model.availabilityZone);
            this.filters(model.filters);
            this.includeMarketplace(model.includeMarketplace);
            this.instanceType(model.instanceType);
            this.maxDuration(model.maxDuration);
            this.maxInstanceCount(model.maxInstanceCount);
            this.minDuration(model.minDuration);
            this.offeringClass(model.offeringClass);
            this.productDescription(model.productDescription);
            this.reservedInstancesOfferingIds(model.reservedInstancesOfferingIds);
            this.instanceTenancy(model.instanceTenancy);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.offeringType(model.offeringType);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final List<Filter.Builder> getFilters() {
            List<Filter.Builder> result = FilterListCopier.copyToBuilder(this.filters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFilters(Collection<Filter.BuilderImpl> filters) {
            this.filters = FilterListCopier.copyFromBuilder(filters);
        }

        @Override
        @Transient
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Filter ... filters) {
            this.filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder filters(Consumer<Filter.Builder> ... filters) {
            this.filters(Stream.of(filters).map(c -> (Filter)((Filter.Builder)Filter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getIncludeMarketplace() {
            return this.includeMarketplace;
        }

        public final void setIncludeMarketplace(Boolean includeMarketplace) {
            this.includeMarketplace = includeMarketplace;
        }

        @Override
        @Transient
        public final Builder includeMarketplace(Boolean includeMarketplace) {
            this.includeMarketplace = includeMarketplace;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        @Transient
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        @Transient
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final Long getMaxDuration() {
            return this.maxDuration;
        }

        public final void setMaxDuration(Long maxDuration) {
            this.maxDuration = maxDuration;
        }

        @Override
        @Transient
        public final Builder maxDuration(Long maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final Integer getMaxInstanceCount() {
            return this.maxInstanceCount;
        }

        public final void setMaxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
        }

        @Override
        @Transient
        public final Builder maxInstanceCount(Integer maxInstanceCount) {
            this.maxInstanceCount = maxInstanceCount;
            return this;
        }

        public final Long getMinDuration() {
            return this.minDuration;
        }

        public final void setMinDuration(Long minDuration) {
            this.minDuration = minDuration;
        }

        @Override
        @Transient
        public final Builder minDuration(Long minDuration) {
            this.minDuration = minDuration;
            return this;
        }

        public final String getOfferingClass() {
            return this.offeringClass;
        }

        public final void setOfferingClass(String offeringClass) {
            this.offeringClass = offeringClass;
        }

        @Override
        @Transient
        public final Builder offeringClass(String offeringClass) {
            this.offeringClass = offeringClass;
            return this;
        }

        @Override
        @Transient
        public final Builder offeringClass(OfferingClassType offeringClass) {
            this.offeringClass(offeringClass == null ? null : offeringClass.toString());
            return this;
        }

        public final String getProductDescription() {
            return this.productDescription;
        }

        public final void setProductDescription(String productDescription) {
            this.productDescription = productDescription;
        }

        @Override
        @Transient
        public final Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        @Override
        @Transient
        public final Builder productDescription(RIProductDescription productDescription) {
            this.productDescription(productDescription == null ? null : productDescription.toString());
            return this;
        }

        public final Collection<String> getReservedInstancesOfferingIds() {
            if (this.reservedInstancesOfferingIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.reservedInstancesOfferingIds;
        }

        public final void setReservedInstancesOfferingIds(Collection<String> reservedInstancesOfferingIds) {
            this.reservedInstancesOfferingIds = ReservedInstancesOfferingIdStringListCopier.copy(reservedInstancesOfferingIds);
        }

        @Override
        @Transient
        public final Builder reservedInstancesOfferingIds(Collection<String> reservedInstancesOfferingIds) {
            this.reservedInstancesOfferingIds = ReservedInstancesOfferingIdStringListCopier.copy(reservedInstancesOfferingIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder reservedInstancesOfferingIds(String ... reservedInstancesOfferingIds) {
            this.reservedInstancesOfferingIds(Arrays.asList(reservedInstancesOfferingIds));
            return this;
        }

        public final String getInstanceTenancy() {
            return this.instanceTenancy;
        }

        public final void setInstanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
        }

        @Override
        @Transient
        public final Builder instanceTenancy(String instanceTenancy) {
            this.instanceTenancy = instanceTenancy;
            return this;
        }

        @Override
        @Transient
        public final Builder instanceTenancy(Tenancy instanceTenancy) {
            this.instanceTenancy(instanceTenancy == null ? null : instanceTenancy.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        @Transient
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getOfferingType() {
            return this.offeringType;
        }

        public final void setOfferingType(String offeringType) {
            this.offeringType = offeringType;
        }

        @Override
        @Transient
        public final Builder offeringType(String offeringType) {
            this.offeringType = offeringType;
            return this;
        }

        @Override
        @Transient
        public final Builder offeringType(OfferingTypeValues offeringType) {
            this.offeringType(offeringType == null ? null : offeringType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeReservedInstancesOfferingsRequest build() {
            return new DescribeReservedInstancesOfferingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeReservedInstancesOfferingsRequest> {
        public Builder availabilityZone(String var1);

        public Builder filters(Collection<Filter> var1);

        public Builder filters(Filter ... var1);

        public Builder filters(Consumer<Filter.Builder> ... var1);

        public Builder includeMarketplace(Boolean var1);

        public Builder instanceType(String var1);

        public Builder instanceType(InstanceType var1);

        public Builder maxDuration(Long var1);

        public Builder maxInstanceCount(Integer var1);

        public Builder minDuration(Long var1);

        public Builder offeringClass(String var1);

        public Builder offeringClass(OfferingClassType var1);

        public Builder productDescription(String var1);

        public Builder productDescription(RIProductDescription var1);

        public Builder reservedInstancesOfferingIds(Collection<String> var1);

        public Builder reservedInstancesOfferingIds(String ... var1);

        public Builder instanceTenancy(String var1);

        public Builder instanceTenancy(Tenancy var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder offeringType(String var1);

        public Builder offeringType(OfferingTypeValues var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

