/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InterfacePermissionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNetworkInterfacePermissionRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateNetworkInterfacePermissionRequest> {
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(CreateNetworkInterfacePermissionRequest.getter(CreateNetworkInterfacePermissionRequest::networkInterfaceId)).setter(CreateNetworkInterfacePermissionRequest.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("NetworkInterfaceId").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsAccountId").getter(CreateNetworkInterfacePermissionRequest.getter(CreateNetworkInterfacePermissionRequest::awsAccountId)).setter(CreateNetworkInterfacePermissionRequest.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsAccountId").unmarshallLocationName("AwsAccountId").build()}).build();
    private static final SdkField<String> AWS_SERVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AwsService").getter(CreateNetworkInterfacePermissionRequest.getter(CreateNetworkInterfacePermissionRequest::awsService)).setter(CreateNetworkInterfacePermissionRequest.setter(Builder::awsService)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsService").unmarshallLocationName("AwsService").build()}).build();
    private static final SdkField<String> PERMISSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Permission").getter(CreateNetworkInterfacePermissionRequest.getter(CreateNetworkInterfacePermissionRequest::permissionAsString)).setter(CreateNetworkInterfacePermissionRequest.setter(Builder::permission)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permission").unmarshallLocationName("Permission").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_INTERFACE_ID_FIELD, AWS_ACCOUNT_ID_FIELD, AWS_SERVICE_FIELD, PERMISSION_FIELD));
    private final String networkInterfaceId;
    private final String awsAccountId;
    private final String awsService;
    private final String permission;

    private CreateNetworkInterfacePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.networkInterfaceId = builder.networkInterfaceId;
        this.awsAccountId = builder.awsAccountId;
        this.awsService = builder.awsService;
        this.permission = builder.permission;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String awsService() {
        return this.awsService;
    }

    public final InterfacePermissionType permission() {
        return InterfacePermissionType.fromValue(this.permission);
    }

    public final String permissionAsString() {
        return this.permission;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsService());
        hashCode = 31 * hashCode + Objects.hashCode(this.permissionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkInterfacePermissionRequest)) {
            return false;
        }
        CreateNetworkInterfacePermissionRequest other = (CreateNetworkInterfacePermissionRequest)((Object)obj);
        return Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.awsService(), other.awsService()) && Objects.equals(this.permissionAsString(), other.permissionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateNetworkInterfacePermissionRequest").add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("AwsAccountId", (Object)this.awsAccountId()).add("AwsService", (Object)this.awsService()).add("Permission", (Object)this.permissionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "AwsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "AwsService": {
                return Optional.ofNullable(clazz.cast(this.awsService()));
            }
            case "Permission": {
                return Optional.ofNullable(clazz.cast(this.permissionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkInterfacePermissionRequest, T> g) {
        return obj -> g.apply((CreateNetworkInterfacePermissionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String networkInterfaceId;
        private String awsAccountId;
        private String awsService;
        private String permission;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkInterfacePermissionRequest model) {
            super(model);
            this.networkInterfaceId(model.networkInterfaceId);
            this.awsAccountId(model.awsAccountId);
            this.awsService(model.awsService);
            this.permission(model.permission);
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        @Transient
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        @Transient
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsService() {
            return this.awsService;
        }

        public final void setAwsService(String awsService) {
            this.awsService = awsService;
        }

        @Override
        @Transient
        public final Builder awsService(String awsService) {
            this.awsService = awsService;
            return this;
        }

        public final String getPermission() {
            return this.permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        @Transient
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        @Transient
        public final Builder permission(InterfacePermissionType permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkInterfacePermissionRequest build() {
            return new CreateNetworkInterfacePermissionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNetworkInterfacePermissionRequest> {
        public Builder networkInterfaceId(String var1);

        public Builder awsAccountId(String var1);

        public Builder awsService(String var1);

        public Builder permission(String var1);

        public Builder permission(InterfacePermissionType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

