/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.InstanceEventWindowAssociationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateInstanceEventWindowRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, AssociateInstanceEventWindowRequest> {
    private static final SdkField<String> INSTANCE_EVENT_WINDOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceEventWindowId").getter(AssociateInstanceEventWindowRequest.getter(AssociateInstanceEventWindowRequest::instanceEventWindowId)).setter(AssociateInstanceEventWindowRequest.setter(Builder::instanceEventWindowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceEventWindowId").unmarshallLocationName("InstanceEventWindowId").build()}).build();
    private static final SdkField<InstanceEventWindowAssociationRequest> ASSOCIATION_TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AssociationTarget").getter(AssociateInstanceEventWindowRequest.getter(AssociateInstanceEventWindowRequest::associationTarget)).setter(AssociateInstanceEventWindowRequest.setter(Builder::associationTarget)).constructor(InstanceEventWindowAssociationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationTarget").unmarshallLocationName("AssociationTarget").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_EVENT_WINDOW_ID_FIELD, ASSOCIATION_TARGET_FIELD));
    private final String instanceEventWindowId;
    private final InstanceEventWindowAssociationRequest associationTarget;

    private AssociateInstanceEventWindowRequest(BuilderImpl builder) {
        super(builder);
        this.instanceEventWindowId = builder.instanceEventWindowId;
        this.associationTarget = builder.associationTarget;
    }

    public final String instanceEventWindowId() {
        return this.instanceEventWindowId;
    }

    public final InstanceEventWindowAssociationRequest associationTarget() {
        return this.associationTarget;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceEventWindowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationTarget());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateInstanceEventWindowRequest)) {
            return false;
        }
        AssociateInstanceEventWindowRequest other = (AssociateInstanceEventWindowRequest)((Object)obj);
        return Objects.equals(this.instanceEventWindowId(), other.instanceEventWindowId()) && Objects.equals(this.associationTarget(), other.associationTarget());
    }

    public final String toString() {
        return ToString.builder((String)"AssociateInstanceEventWindowRequest").add("InstanceEventWindowId", (Object)this.instanceEventWindowId()).add("AssociationTarget", (Object)this.associationTarget()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceEventWindowId": {
                return Optional.ofNullable(clazz.cast(this.instanceEventWindowId()));
            }
            case "AssociationTarget": {
                return Optional.ofNullable(clazz.cast(this.associationTarget()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateInstanceEventWindowRequest, T> g) {
        return obj -> g.apply((AssociateInstanceEventWindowRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String instanceEventWindowId;
        private InstanceEventWindowAssociationRequest associationTarget;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateInstanceEventWindowRequest model) {
            super(model);
            this.instanceEventWindowId(model.instanceEventWindowId);
            this.associationTarget(model.associationTarget);
        }

        public final String getInstanceEventWindowId() {
            return this.instanceEventWindowId;
        }

        public final void setInstanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
        }

        @Override
        @Transient
        public final Builder instanceEventWindowId(String instanceEventWindowId) {
            this.instanceEventWindowId = instanceEventWindowId;
            return this;
        }

        public final InstanceEventWindowAssociationRequest.Builder getAssociationTarget() {
            return this.associationTarget != null ? this.associationTarget.toBuilder() : null;
        }

        public final void setAssociationTarget(InstanceEventWindowAssociationRequest.BuilderImpl associationTarget) {
            this.associationTarget = associationTarget != null ? associationTarget.build() : null;
        }

        @Override
        @Transient
        public final Builder associationTarget(InstanceEventWindowAssociationRequest associationTarget) {
            this.associationTarget = associationTarget;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateInstanceEventWindowRequest build() {
            return new AssociateInstanceEventWindowRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateInstanceEventWindowRequest> {
        public Builder instanceEventWindowId(String var1);

        public Builder associationTarget(InstanceEventWindowAssociationRequest var1);

        default public Builder associationTarget(Consumer<InstanceEventWindowAssociationRequest.Builder> associationTarget) {
            return this.associationTarget((InstanceEventWindowAssociationRequest)((InstanceEventWindowAssociationRequest.Builder)InstanceEventWindowAssociationRequest.builder().applyMutation(associationTarget)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

