/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.DomainType;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Address
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Address> {
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(Address.getter(Address::instanceId)).setter(Address.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("instanceId").build()}).build();
    private static final SdkField<String> PUBLIC_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIp").getter(Address.getter(Address::publicIp)).setter(Address.setter(Builder::publicIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIp").unmarshallLocationName("publicIp").build()}).build();
    private static final SdkField<String> ALLOCATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AllocationId").getter(Address.getter(Address::allocationId)).setter(Address.setter(Builder::allocationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocationId").unmarshallLocationName("allocationId").build()}).build();
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssociationId").getter(Address.getter(Address::associationId)).setter(Address.setter(Builder::associationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociationId").unmarshallLocationName("associationId").build()}).build();
    private static final SdkField<String> DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Domain").getter(Address.getter(Address::domainAsString)).setter(Address.setter(Builder::domain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Domain").unmarshallLocationName("domain").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(Address.getter(Address::networkInterfaceId)).setter(Address.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceOwnerId").getter(Address.getter(Address::networkInterfaceOwnerId)).setter(Address.setter(Builder::networkInterfaceOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceOwnerId").unmarshallLocationName("networkInterfaceOwnerId").build()}).build();
    private static final SdkField<String> PRIVATE_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PrivateIpAddress").getter(Address.getter(Address::privateIpAddress)).setter(Address.setter(Builder::privateIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrivateIpAddress").unmarshallLocationName("privateIpAddress").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Address.getter(Address::tags)).setter(Address.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> PUBLIC_IPV4_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PublicIpv4Pool").getter(Address.getter(Address::publicIpv4Pool)).setter(Address.setter(Builder::publicIpv4Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicIpv4Pool").unmarshallLocationName("publicIpv4Pool").build()}).build();
    private static final SdkField<String> NETWORK_BORDER_GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkBorderGroup").getter(Address.getter(Address::networkBorderGroup)).setter(Address.setter(Builder::networkBorderGroup)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkBorderGroup").unmarshallLocationName("networkBorderGroup").build()}).build();
    private static final SdkField<String> CUSTOMER_OWNED_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerOwnedIp").getter(Address.getter(Address::customerOwnedIp)).setter(Address.setter(Builder::customerOwnedIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIp").unmarshallLocationName("customerOwnedIp").build()}).build();
    private static final SdkField<String> CUSTOMER_OWNED_IPV4_POOL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerOwnedIpv4Pool").getter(Address.getter(Address::customerOwnedIpv4Pool)).setter(Address.setter(Builder::customerOwnedIpv4Pool)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerOwnedIpv4Pool").unmarshallLocationName("customerOwnedIpv4Pool").build()}).build();
    private static final SdkField<String> CARRIER_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CarrierIp").getter(Address.getter(Address::carrierIp)).setter(Address.setter(Builder::carrierIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CarrierIp").unmarshallLocationName("carrierIp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_ID_FIELD, PUBLIC_IP_FIELD, ALLOCATION_ID_FIELD, ASSOCIATION_ID_FIELD, DOMAIN_FIELD, NETWORK_INTERFACE_ID_FIELD, NETWORK_INTERFACE_OWNER_ID_FIELD, PRIVATE_IP_ADDRESS_FIELD, TAGS_FIELD, PUBLIC_IPV4_POOL_FIELD, NETWORK_BORDER_GROUP_FIELD, CUSTOMER_OWNED_IP_FIELD, CUSTOMER_OWNED_IPV4_POOL_FIELD, CARRIER_IP_FIELD));
    private static final long serialVersionUID = 1L;
    private final String instanceId;
    private final String publicIp;
    private final String allocationId;
    private final String associationId;
    private final String domain;
    private final String networkInterfaceId;
    private final String networkInterfaceOwnerId;
    private final String privateIpAddress;
    private final List<Tag> tags;
    private final String publicIpv4Pool;
    private final String networkBorderGroup;
    private final String customerOwnedIp;
    private final String customerOwnedIpv4Pool;
    private final String carrierIp;

    private Address(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.publicIp = builder.publicIp;
        this.allocationId = builder.allocationId;
        this.associationId = builder.associationId;
        this.domain = builder.domain;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.networkInterfaceOwnerId = builder.networkInterfaceOwnerId;
        this.privateIpAddress = builder.privateIpAddress;
        this.tags = builder.tags;
        this.publicIpv4Pool = builder.publicIpv4Pool;
        this.networkBorderGroup = builder.networkBorderGroup;
        this.customerOwnedIp = builder.customerOwnedIp;
        this.customerOwnedIpv4Pool = builder.customerOwnedIpv4Pool;
        this.carrierIp = builder.carrierIp;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String publicIp() {
        return this.publicIp;
    }

    public final String allocationId() {
        return this.allocationId;
    }

    public final String associationId() {
        return this.associationId;
    }

    public final DomainType domain() {
        return DomainType.fromValue(this.domain);
    }

    public final String domainAsString() {
        return this.domain;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String networkInterfaceOwnerId() {
        return this.networkInterfaceOwnerId;
    }

    public final String privateIpAddress() {
        return this.privateIpAddress;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String publicIpv4Pool() {
        return this.publicIpv4Pool;
    }

    public final String networkBorderGroup() {
        return this.networkBorderGroup;
    }

    public final String customerOwnedIp() {
        return this.customerOwnedIp;
    }

    public final String customerOwnedIpv4Pool() {
        return this.customerOwnedIpv4Pool;
    }

    public final String carrierIp() {
        return this.carrierIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.allocationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.associationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.privateIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.publicIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkBorderGroup());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerOwnedIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerOwnedIpv4Pool());
        hashCode = 31 * hashCode + Objects.hashCode(this.carrierIp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address)obj;
        return Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.publicIp(), other.publicIp()) && Objects.equals(this.allocationId(), other.allocationId()) && Objects.equals(this.associationId(), other.associationId()) && Objects.equals(this.domainAsString(), other.domainAsString()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.networkInterfaceOwnerId(), other.networkInterfaceOwnerId()) && Objects.equals(this.privateIpAddress(), other.privateIpAddress()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.publicIpv4Pool(), other.publicIpv4Pool()) && Objects.equals(this.networkBorderGroup(), other.networkBorderGroup()) && Objects.equals(this.customerOwnedIp(), other.customerOwnedIp()) && Objects.equals(this.customerOwnedIpv4Pool(), other.customerOwnedIpv4Pool()) && Objects.equals(this.carrierIp(), other.carrierIp());
    }

    public final String toString() {
        return ToString.builder((String)"Address").add("InstanceId", (Object)this.instanceId()).add("PublicIp", (Object)this.publicIp()).add("AllocationId", (Object)this.allocationId()).add("AssociationId", (Object)this.associationId()).add("Domain", (Object)this.domainAsString()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("NetworkInterfaceOwnerId", (Object)this.networkInterfaceOwnerId()).add("PrivateIpAddress", (Object)this.privateIpAddress()).add("Tags", this.hasTags() ? this.tags() : null).add("PublicIpv4Pool", (Object)this.publicIpv4Pool()).add("NetworkBorderGroup", (Object)this.networkBorderGroup()).add("CustomerOwnedIp", (Object)this.customerOwnedIp()).add("CustomerOwnedIpv4Pool", (Object)this.customerOwnedIpv4Pool()).add("CarrierIp", (Object)this.carrierIp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "PublicIp": {
                return Optional.ofNullable(clazz.cast(this.publicIp()));
            }
            case "AllocationId": {
                return Optional.ofNullable(clazz.cast(this.allocationId()));
            }
            case "AssociationId": {
                return Optional.ofNullable(clazz.cast(this.associationId()));
            }
            case "Domain": {
                return Optional.ofNullable(clazz.cast(this.domainAsString()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "NetworkInterfaceOwnerId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceOwnerId()));
            }
            case "PrivateIpAddress": {
                return Optional.ofNullable(clazz.cast(this.privateIpAddress()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "PublicIpv4Pool": {
                return Optional.ofNullable(clazz.cast(this.publicIpv4Pool()));
            }
            case "NetworkBorderGroup": {
                return Optional.ofNullable(clazz.cast(this.networkBorderGroup()));
            }
            case "CustomerOwnedIp": {
                return Optional.ofNullable(clazz.cast(this.customerOwnedIp()));
            }
            case "CustomerOwnedIpv4Pool": {
                return Optional.ofNullable(clazz.cast(this.customerOwnedIpv4Pool()));
            }
            case "CarrierIp": {
                return Optional.ofNullable(clazz.cast(this.carrierIp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Address, T> g) {
        return obj -> g.apply((Address)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private String publicIp;
        private String allocationId;
        private String associationId;
        private String domain;
        private String networkInterfaceId;
        private String networkInterfaceOwnerId;
        private String privateIpAddress;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String publicIpv4Pool;
        private String networkBorderGroup;
        private String customerOwnedIp;
        private String customerOwnedIpv4Pool;
        private String carrierIp;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            this.instanceId(model.instanceId);
            this.publicIp(model.publicIp);
            this.allocationId(model.allocationId);
            this.associationId(model.associationId);
            this.domain(model.domain);
            this.networkInterfaceId(model.networkInterfaceId);
            this.networkInterfaceOwnerId(model.networkInterfaceOwnerId);
            this.privateIpAddress(model.privateIpAddress);
            this.tags(model.tags);
            this.publicIpv4Pool(model.publicIpv4Pool);
            this.networkBorderGroup(model.networkBorderGroup);
            this.customerOwnedIp(model.customerOwnedIp);
            this.customerOwnedIpv4Pool(model.customerOwnedIpv4Pool);
            this.carrierIp(model.carrierIp);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        @Transient
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getPublicIp() {
            return this.publicIp;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        @Override
        @Transient
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final String getAllocationId() {
            return this.allocationId;
        }

        public final void setAllocationId(String allocationId) {
            this.allocationId = allocationId;
        }

        @Override
        @Transient
        public final Builder allocationId(String allocationId) {
            this.allocationId = allocationId;
            return this;
        }

        public final String getAssociationId() {
            return this.associationId;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        @Transient
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final String getDomain() {
            return this.domain;
        }

        public final void setDomain(String domain) {
            this.domain = domain;
        }

        @Override
        @Transient
        public final Builder domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        @Transient
        public final Builder domain(DomainType domain) {
            this.domain(domain == null ? null : domain.toString());
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        @Transient
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getNetworkInterfaceOwnerId() {
            return this.networkInterfaceOwnerId;
        }

        public final void setNetworkInterfaceOwnerId(String networkInterfaceOwnerId) {
            this.networkInterfaceOwnerId = networkInterfaceOwnerId;
        }

        @Override
        @Transient
        public final Builder networkInterfaceOwnerId(String networkInterfaceOwnerId) {
            this.networkInterfaceOwnerId = networkInterfaceOwnerId;
            return this;
        }

        public final String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        @Override
        @Transient
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPublicIpv4Pool() {
            return this.publicIpv4Pool;
        }

        public final void setPublicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
        }

        @Override
        @Transient
        public final Builder publicIpv4Pool(String publicIpv4Pool) {
            this.publicIpv4Pool = publicIpv4Pool;
            return this;
        }

        public final String getNetworkBorderGroup() {
            return this.networkBorderGroup;
        }

        public final void setNetworkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
        }

        @Override
        @Transient
        public final Builder networkBorderGroup(String networkBorderGroup) {
            this.networkBorderGroup = networkBorderGroup;
            return this;
        }

        public final String getCustomerOwnedIp() {
            return this.customerOwnedIp;
        }

        public final void setCustomerOwnedIp(String customerOwnedIp) {
            this.customerOwnedIp = customerOwnedIp;
        }

        @Override
        @Transient
        public final Builder customerOwnedIp(String customerOwnedIp) {
            this.customerOwnedIp = customerOwnedIp;
            return this;
        }

        public final String getCustomerOwnedIpv4Pool() {
            return this.customerOwnedIpv4Pool;
        }

        public final void setCustomerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
        }

        @Override
        @Transient
        public final Builder customerOwnedIpv4Pool(String customerOwnedIpv4Pool) {
            this.customerOwnedIpv4Pool = customerOwnedIpv4Pool;
            return this;
        }

        public final String getCarrierIp() {
            return this.carrierIp;
        }

        public final void setCarrierIp(String carrierIp) {
            this.carrierIp = carrierIp;
        }

        @Override
        @Transient
        public final Builder carrierIp(String carrierIp) {
            this.carrierIp = carrierIp;
            return this;
        }

        public Address build() {
            return new Address(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Address> {
        public Builder instanceId(String var1);

        public Builder publicIp(String var1);

        public Builder allocationId(String var1);

        public Builder associationId(String var1);

        public Builder domain(String var1);

        public Builder domain(DomainType var1);

        public Builder networkInterfaceId(String var1);

        public Builder networkInterfaceOwnerId(String var1);

        public Builder privateIpAddress(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder publicIpv4Pool(String var1);

        public Builder networkBorderGroup(String var1);

        public Builder customerOwnedIp(String var1);

        public Builder customerOwnedIpv4Pool(String var1);

        public Builder carrierIp(String var1);
    }
}

