/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTagsRequest extends CostExplorerRequest implements
        ToCopyableBuilder<GetTagsRequest.Builder, GetTagsRequest> {
    private static final SdkField<String> SEARCH_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SearchString").getter(getter(GetTagsRequest::searchString)).setter(setter(Builder::searchString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchString").build()).build();

    private static final SdkField<DateInterval> TIME_PERIOD_FIELD = SdkField.<DateInterval> builder(MarshallingType.SDK_POJO)
            .memberName("TimePeriod").getter(getter(GetTagsRequest::timePeriod)).setter(setter(Builder::timePeriod))
            .constructor(DateInterval::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimePeriod").build()).build();

    private static final SdkField<String> TAG_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("TagKey")
            .getter(getter(GetTagsRequest::tagKey)).setter(setter(Builder::tagKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKey").build()).build();

    private static final SdkField<Expression> FILTER_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .memberName("Filter").getter(getter(GetTagsRequest::filter)).setter(setter(Builder::filter))
            .constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filter").build()).build();

    private static final SdkField<List<SortDefinition>> SORT_BY_FIELD = SdkField
            .<List<SortDefinition>> builder(MarshallingType.LIST)
            .memberName("SortBy")
            .getter(getter(GetTagsRequest::sortBy))
            .setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SortDefinition> builder(MarshallingType.SDK_POJO)
                                            .constructor(SortDefinition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(GetTagsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetTagsRequest::nextPageToken)).setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_STRING_FIELD,
            TIME_PERIOD_FIELD, TAG_KEY_FIELD, FILTER_FIELD, SORT_BY_FIELD, MAX_RESULTS_FIELD, NEXT_PAGE_TOKEN_FIELD));

    private final String searchString;

    private final DateInterval timePeriod;

    private final String tagKey;

    private final Expression filter;

    private final List<SortDefinition> sortBy;

    private final Integer maxResults;

    private final String nextPageToken;

    private GetTagsRequest(BuilderImpl builder) {
        super(builder);
        this.searchString = builder.searchString;
        this.timePeriod = builder.timePeriod;
        this.tagKey = builder.tagKey;
        this.filter = builder.filter;
        this.sortBy = builder.sortBy;
        this.maxResults = builder.maxResults;
        this.nextPageToken = builder.nextPageToken;
    }

    /**
     * <p>
     * The value that you want to search for.
     * </p>
     * 
     * @return The value that you want to search for.
     */
    public final String searchString() {
        return searchString;
    }

    /**
     * <p>
     * The start and end dates for retrieving the dimension values. The start date is inclusive, but the end date is
     * exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is
     * <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
     * including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
     * </p>
     * 
     * @return The start and end dates for retrieving the dimension values. The start date is inclusive, but the end
     *         date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is
     *         <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
     *         including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
     */
    public final DateInterval timePeriod() {
        return timePeriod;
    }

    /**
     * <p>
     * The key of the tag that you want to return values for.
     * </p>
     * 
     * @return The key of the tag that you want to return values for.
     */
    public final String tagKey() {
        return tagKey;
    }

    /**
     * Returns the value of the Filter property for this object.
     * 
     * @return The value of the Filter property for this object.
     */
    public final Expression filter() {
        return filter;
    }

    /**
     * Returns true if the SortBy property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSortBy() {
        return sortBy != null && !(sortBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The value by which you want to sort the data.
     * </p>
     * <p>
     * The key represents cost and usage metrics. The following values are supported:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>BlendedCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UnblendedCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AmortizedCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NetAmortizedCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NetUnblendedCost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>UsageQuantity</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NormalizedUsageAmount</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
     * </p>
     * <p>
     * When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSortBy()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The value by which you want to sort the data.</p>
     *         <p>
     *         The key represents cost and usage metrics. The following values are supported:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>BlendedCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UnblendedCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AmortizedCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NetAmortizedCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NetUnblendedCost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>UsageQuantity</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NormalizedUsageAmount</code>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
     *         </p>
     *         <p>
     *         When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not
     *         supported.
     */
    public final List<SortDefinition> sortBy() {
        return sortBy;
    }

    /**
     * <p>
     * This field is only used when SortBy is provided in the request. The maximum number of objects that to be returned
     * for this request. If MaxResults is not specified with SortBy, the request will return 1000 results as the default
     * value for this parameter.
     * </p>
     * <p>
     * For <code>GetTags</code>, MaxResults has an upper limit of 1000.
     * </p>
     * 
     * @return This field is only used when SortBy is provided in the request. The maximum number of objects that to be
     *         returned for this request. If MaxResults is not specified with SortBy, the request will return 1000
     *         results as the default value for this parameter.</p>
     *         <p>
     *         For <code>GetTags</code>, MaxResults has an upper limit of 1000.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. AWS provides the token when the response from a previous call has
     * more results than the maximum page size.
     * </p>
     * 
     * @return The token to retrieve the next set of results. AWS provides the token when the response from a previous
     *         call has more results than the maximum page size.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(searchString());
        hashCode = 31 * hashCode + Objects.hashCode(timePeriod());
        hashCode = 31 * hashCode + Objects.hashCode(tagKey());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(hasSortBy() ? sortBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTagsRequest)) {
            return false;
        }
        GetTagsRequest other = (GetTagsRequest) obj;
        return Objects.equals(searchString(), other.searchString()) && Objects.equals(timePeriod(), other.timePeriod())
                && Objects.equals(tagKey(), other.tagKey()) && Objects.equals(filter(), other.filter())
                && hasSortBy() == other.hasSortBy() && Objects.equals(sortBy(), other.sortBy())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextPageToken(), other.nextPageToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTagsRequest").add("SearchString", searchString()).add("TimePeriod", timePeriod())
                .add("TagKey", tagKey()).add("Filter", filter()).add("SortBy", hasSortBy() ? sortBy() : null)
                .add("MaxResults", maxResults()).add("NextPageToken", nextPageToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SearchString":
            return Optional.ofNullable(clazz.cast(searchString()));
        case "TimePeriod":
            return Optional.ofNullable(clazz.cast(timePeriod()));
        case "TagKey":
            return Optional.ofNullable(clazz.cast(tagKey()));
        case "Filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortBy()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetTagsRequest, T> g) {
        return obj -> g.apply((GetTagsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTagsRequest> {
        /**
         * <p>
         * The value that you want to search for.
         * </p>
         * 
         * @param searchString
         *        The value that you want to search for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchString(String searchString);

        /**
         * <p>
         * The start and end dates for retrieving the dimension values. The start date is inclusive, but the end date is
         * exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is
         * <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
         * including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
         * </p>
         * 
         * @param timePeriod
         *        The start and end dates for retrieving the dimension values. The start date is inclusive, but the end
         *        date is exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code>
         *        is <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up
         *        to and including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timePeriod(DateInterval timePeriod);

        /**
         * <p>
         * The start and end dates for retrieving the dimension values. The start date is inclusive, but the end date is
         * exclusive. For example, if <code>start</code> is <code>2017-01-01</code> and <code>end</code> is
         * <code>2017-05-01</code>, then the cost and usage data is retrieved from <code>2017-01-01</code> up to and
         * including <code>2017-04-30</code> but not including <code>2017-05-01</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link DateInterval.Builder} avoiding the need to
         * create one manually via {@link DateInterval#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateInterval.Builder#build()} is called immediately and its
         * result is passed to {@link #timePeriod(DateInterval)}.
         * 
         * @param timePeriod
         *        a consumer that will call methods on {@link DateInterval.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timePeriod(DateInterval)
         */
        default Builder timePeriod(Consumer<DateInterval.Builder> timePeriod) {
            return timePeriod(DateInterval.builder().applyMutation(timePeriod).build());
        }

        /**
         * <p>
         * The key of the tag that you want to return values for.
         * </p>
         * 
         * @param tagKey
         *        The key of the tag that you want to return values for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKey(String tagKey);

        /**
         * Sets the value of the Filter property for this object.
         *
         * @param filter
         *        The new value for the Filter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(Expression filter);

        /**
         * Sets the value of the Filter property for this object.
         *
         * This is a convenience that creates an instance of the {@link Expression.Builder} avoiding the need to create
         * one manually via {@link Expression#builder()}.
         *
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #filter(Expression)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(Expression)
         */
        default Builder filter(Consumer<Expression.Builder> filter) {
            return filter(Expression.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The value by which you want to sort the data.
         * </p>
         * <p>
         * The key represents cost and usage metrics. The following values are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BlendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetAmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetUnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UsageQuantity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NormalizedUsageAmount</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         * </p>
         * <p>
         * When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.
         * </p>
         * 
         * @param sortBy
         *        The value by which you want to sort the data.</p>
         *        <p>
         *        The key represents cost and usage metrics. The following values are supported:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BlendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UnblendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AmortizedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NetAmortizedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NetUnblendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UsageQuantity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NormalizedUsageAmount</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         *        </p>
         *        <p>
         *        When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not
         *        supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(Collection<SortDefinition> sortBy);

        /**
         * <p>
         * The value by which you want to sort the data.
         * </p>
         * <p>
         * The key represents cost and usage metrics. The following values are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BlendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetAmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetUnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UsageQuantity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NormalizedUsageAmount</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         * </p>
         * <p>
         * When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.
         * </p>
         * 
         * @param sortBy
         *        The value by which you want to sort the data.</p>
         *        <p>
         *        The key represents cost and usage metrics. The following values are supported:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>BlendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UnblendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AmortizedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NetAmortizedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NetUnblendedCost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>UsageQuantity</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NormalizedUsageAmount</code>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         *        </p>
         *        <p>
         *        When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not
         *        supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortBy(SortDefinition... sortBy);

        /**
         * <p>
         * The value by which you want to sort the data.
         * </p>
         * <p>
         * The key represents cost and usage metrics. The following values are supported:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>BlendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetAmortizedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NetUnblendedCost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>UsageQuantity</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NormalizedUsageAmount</code>
         * </p>
         * </li>
         * </ul>
         * <p>
         * Supported values for <code>SortOrder</code> are <code>ASCENDING</code> or <code>DESCENDING</code>.
         * </p>
         * <p>
         * When using <code>SortBy</code>, <code>NextPageToken</code> and <code>SearchString</code> are not supported.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SortDefinition>.Builder} avoiding the need
         * to create one manually via {@link List<SortDefinition>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SortDefinition>.Builder#build()} is called immediately and
         * its result is passed to {@link #sortBy(List<SortDefinition>)}.
         * 
         * @param sortBy
         *        a consumer that will call methods on {@link List<SortDefinition>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortBy(List<SortDefinition>)
         */
        Builder sortBy(Consumer<SortDefinition.Builder>... sortBy);

        /**
         * <p>
         * This field is only used when SortBy is provided in the request. The maximum number of objects that to be
         * returned for this request. If MaxResults is not specified with SortBy, the request will return 1000 results
         * as the default value for this parameter.
         * </p>
         * <p>
         * For <code>GetTags</code>, MaxResults has an upper limit of 1000.
         * </p>
         * 
         * @param maxResults
         *        This field is only used when SortBy is provided in the request. The maximum number of objects that to
         *        be returned for this request. If MaxResults is not specified with SortBy, the request will return 1000
         *        results as the default value for this parameter.</p>
         *        <p>
         *        For <code>GetTags</code>, MaxResults has an upper limit of 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token to retrieve the next set of results. AWS provides the token when the response from a previous call
         * has more results than the maximum page size.
         * </p>
         * 
         * @param nextPageToken
         *        The token to retrieve the next set of results. AWS provides the token when the response from a
         *        previous call has more results than the maximum page size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CostExplorerRequest.BuilderImpl implements Builder {
        private String searchString;

        private DateInterval timePeriod;

        private String tagKey;

        private Expression filter;

        private List<SortDefinition> sortBy = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextPageToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTagsRequest model) {
            super(model);
            searchString(model.searchString);
            timePeriod(model.timePeriod);
            tagKey(model.tagKey);
            filter(model.filter);
            sortBy(model.sortBy);
            maxResults(model.maxResults);
            nextPageToken(model.nextPageToken);
        }

        public final String getSearchString() {
            return searchString;
        }

        @Override
        public final Builder searchString(String searchString) {
            this.searchString = searchString;
            return this;
        }

        public final void setSearchString(String searchString) {
            this.searchString = searchString;
        }

        public final DateInterval.Builder getTimePeriod() {
            return timePeriod != null ? timePeriod.toBuilder() : null;
        }

        @Override
        public final Builder timePeriod(DateInterval timePeriod) {
            this.timePeriod = timePeriod;
            return this;
        }

        public final void setTimePeriod(DateInterval.BuilderImpl timePeriod) {
            this.timePeriod = timePeriod != null ? timePeriod.build() : null;
        }

        public final String getTagKey() {
            return tagKey;
        }

        @Override
        public final Builder tagKey(String tagKey) {
            this.tagKey = tagKey;
            return this;
        }

        public final void setTagKey(String tagKey) {
            this.tagKey = tagKey;
        }

        public final Expression.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        @Override
        public final Builder filter(Expression filter) {
            this.filter = filter;
            return this;
        }

        public final void setFilter(Expression.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        public final List<SortDefinition.Builder> getSortBy() {
            List<SortDefinition.Builder> result = SortDefinitionsCopier.copyToBuilder(this.sortBy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sortBy(Collection<SortDefinition> sortBy) {
            this.sortBy = SortDefinitionsCopier.copy(sortBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortBy(SortDefinition... sortBy) {
            sortBy(Arrays.asList(sortBy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortBy(Consumer<SortDefinition.Builder>... sortBy) {
            sortBy(Stream.of(sortBy).map(c -> SortDefinition.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSortBy(Collection<SortDefinition.BuilderImpl> sortBy) {
            this.sortBy = SortDefinitionsCopier.copyFromBuilder(sortBy);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTagsRequest build() {
            return new GetTagsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
