/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRightsizingRecommendationResponse extends CostExplorerResponse implements
        ToCopyableBuilder<GetRightsizingRecommendationResponse.Builder, GetRightsizingRecommendationResponse> {
    private static final SdkField<RightsizingRecommendationMetadata> METADATA_FIELD = SdkField
            .<RightsizingRecommendationMetadata> builder(MarshallingType.SDK_POJO).memberName("Metadata")
            .getter(getter(GetRightsizingRecommendationResponse::metadata)).setter(setter(Builder::metadata))
            .constructor(RightsizingRecommendationMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build()).build();

    private static final SdkField<RightsizingRecommendationSummary> SUMMARY_FIELD = SdkField
            .<RightsizingRecommendationSummary> builder(MarshallingType.SDK_POJO).memberName("Summary")
            .getter(getter(GetRightsizingRecommendationResponse::summary)).setter(setter(Builder::summary))
            .constructor(RightsizingRecommendationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Summary").build()).build();

    private static final SdkField<List<RightsizingRecommendation>> RIGHTSIZING_RECOMMENDATIONS_FIELD = SdkField
            .<List<RightsizingRecommendation>> builder(MarshallingType.LIST)
            .memberName("RightsizingRecommendations")
            .getter(getter(GetRightsizingRecommendationResponse::rightsizingRecommendations))
            .setter(setter(Builder::rightsizingRecommendations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RightsizingRecommendations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RightsizingRecommendation> builder(MarshallingType.SDK_POJO)
                                            .constructor(RightsizingRecommendation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_PAGE_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextPageToken").getter(getter(GetRightsizingRecommendationResponse::nextPageToken))
            .setter(setter(Builder::nextPageToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextPageToken").build()).build();

    private static final SdkField<RightsizingRecommendationConfiguration> CONFIGURATION_FIELD = SdkField
            .<RightsizingRecommendationConfiguration> builder(MarshallingType.SDK_POJO).memberName("Configuration")
            .getter(getter(GetRightsizingRecommendationResponse::configuration)).setter(setter(Builder::configuration))
            .constructor(RightsizingRecommendationConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Configuration").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD, SUMMARY_FIELD,
            RIGHTSIZING_RECOMMENDATIONS_FIELD, NEXT_PAGE_TOKEN_FIELD, CONFIGURATION_FIELD));

    private final RightsizingRecommendationMetadata metadata;

    private final RightsizingRecommendationSummary summary;

    private final List<RightsizingRecommendation> rightsizingRecommendations;

    private final String nextPageToken;

    private final RightsizingRecommendationConfiguration configuration;

    private GetRightsizingRecommendationResponse(BuilderImpl builder) {
        super(builder);
        this.metadata = builder.metadata;
        this.summary = builder.summary;
        this.rightsizingRecommendations = builder.rightsizingRecommendations;
        this.nextPageToken = builder.nextPageToken;
        this.configuration = builder.configuration;
    }

    /**
     * <p>
     * Information regarding this specific recommendation set.
     * </p>
     * 
     * @return Information regarding this specific recommendation set.
     */
    public final RightsizingRecommendationMetadata metadata() {
        return metadata;
    }

    /**
     * <p>
     * Summary of this recommendation set.
     * </p>
     * 
     * @return Summary of this recommendation set.
     */
    public final RightsizingRecommendationSummary summary() {
        return summary;
    }

    /**
     * Returns true if the RightsizingRecommendations property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasRightsizingRecommendations() {
        return rightsizingRecommendations != null && !(rightsizingRecommendations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Recommendations to rightsize resources.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRightsizingRecommendations()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Recommendations to rightsize resources.
     */
    public final List<RightsizingRecommendation> rightsizingRecommendations() {
        return rightsizingRecommendations;
    }

    /**
     * <p>
     * The token to retrieve the next set of results.
     * </p>
     * 
     * @return The token to retrieve the next set of results.
     */
    public final String nextPageToken() {
        return nextPageToken;
    }

    /**
     * <p>
     * Enables you to customize recommendations across two attributes. You can choose to view recommendations for
     * instances within the same instance families or across different instance families. You can also choose to view
     * your estimated savings associated with recommendations with consideration of existing Savings Plans or RI
     * benefits, or neither.
     * </p>
     * 
     * @return Enables you to customize recommendations across two attributes. You can choose to view recommendations
     *         for instances within the same instance families or across different instance families. You can also
     *         choose to view your estimated savings associated with recommendations with consideration of existing
     *         Savings Plans or RI benefits, or neither.
     */
    public final RightsizingRecommendationConfiguration configuration() {
        return configuration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(summary());
        hashCode = 31 * hashCode + Objects.hashCode(hasRightsizingRecommendations() ? rightsizingRecommendations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextPageToken());
        hashCode = 31 * hashCode + Objects.hashCode(configuration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRightsizingRecommendationResponse)) {
            return false;
        }
        GetRightsizingRecommendationResponse other = (GetRightsizingRecommendationResponse) obj;
        return Objects.equals(metadata(), other.metadata()) && Objects.equals(summary(), other.summary())
                && hasRightsizingRecommendations() == other.hasRightsizingRecommendations()
                && Objects.equals(rightsizingRecommendations(), other.rightsizingRecommendations())
                && Objects.equals(nextPageToken(), other.nextPageToken())
                && Objects.equals(configuration(), other.configuration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRightsizingRecommendationResponse").add("Metadata", metadata()).add("Summary", summary())
                .add("RightsizingRecommendations", hasRightsizingRecommendations() ? rightsizingRecommendations() : null)
                .add("NextPageToken", nextPageToken()).add("Configuration", configuration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "Summary":
            return Optional.ofNullable(clazz.cast(summary()));
        case "RightsizingRecommendations":
            return Optional.ofNullable(clazz.cast(rightsizingRecommendations()));
        case "NextPageToken":
            return Optional.ofNullable(clazz.cast(nextPageToken()));
        case "Configuration":
            return Optional.ofNullable(clazz.cast(configuration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRightsizingRecommendationResponse, T> g) {
        return obj -> g.apply((GetRightsizingRecommendationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CostExplorerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRightsizingRecommendationResponse> {
        /**
         * <p>
         * Information regarding this specific recommendation set.
         * </p>
         * 
         * @param metadata
         *        Information regarding this specific recommendation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(RightsizingRecommendationMetadata metadata);

        /**
         * <p>
         * Information regarding this specific recommendation set.
         * </p>
         * This is a convenience that creates an instance of the {@link RightsizingRecommendationMetadata.Builder}
         * avoiding the need to create one manually via {@link RightsizingRecommendationMetadata#builder()}.
         *
         * When the {@link Consumer} completes, {@link RightsizingRecommendationMetadata.Builder#build()} is called
         * immediately and its result is passed to {@link #metadata(RightsizingRecommendationMetadata)}.
         * 
         * @param metadata
         *        a consumer that will call methods on {@link RightsizingRecommendationMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadata(RightsizingRecommendationMetadata)
         */
        default Builder metadata(Consumer<RightsizingRecommendationMetadata.Builder> metadata) {
            return metadata(RightsizingRecommendationMetadata.builder().applyMutation(metadata).build());
        }

        /**
         * <p>
         * Summary of this recommendation set.
         * </p>
         * 
         * @param summary
         *        Summary of this recommendation set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder summary(RightsizingRecommendationSummary summary);

        /**
         * <p>
         * Summary of this recommendation set.
         * </p>
         * This is a convenience that creates an instance of the {@link RightsizingRecommendationSummary.Builder}
         * avoiding the need to create one manually via {@link RightsizingRecommendationSummary#builder()}.
         *
         * When the {@link Consumer} completes, {@link RightsizingRecommendationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #summary(RightsizingRecommendationSummary)}.
         * 
         * @param summary
         *        a consumer that will call methods on {@link RightsizingRecommendationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #summary(RightsizingRecommendationSummary)
         */
        default Builder summary(Consumer<RightsizingRecommendationSummary.Builder> summary) {
            return summary(RightsizingRecommendationSummary.builder().applyMutation(summary).build());
        }

        /**
         * <p>
         * Recommendations to rightsize resources.
         * </p>
         * 
         * @param rightsizingRecommendations
         *        Recommendations to rightsize resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rightsizingRecommendations(Collection<RightsizingRecommendation> rightsizingRecommendations);

        /**
         * <p>
         * Recommendations to rightsize resources.
         * </p>
         * 
         * @param rightsizingRecommendations
         *        Recommendations to rightsize resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rightsizingRecommendations(RightsizingRecommendation... rightsizingRecommendations);

        /**
         * <p>
         * Recommendations to rightsize resources.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RightsizingRecommendation>.Builder}
         * avoiding the need to create one manually via {@link List<RightsizingRecommendation>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RightsizingRecommendation>.Builder#build()} is called
         * immediately and its result is passed to {@link #rightsizingRecommendations(List<RightsizingRecommendation>)}.
         * 
         * @param rightsizingRecommendations
         *        a consumer that will call methods on {@link List<RightsizingRecommendation>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rightsizingRecommendations(List<RightsizingRecommendation>)
         */
        Builder rightsizingRecommendations(Consumer<RightsizingRecommendation.Builder>... rightsizingRecommendations);

        /**
         * <p>
         * The token to retrieve the next set of results.
         * </p>
         * 
         * @param nextPageToken
         *        The token to retrieve the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextPageToken(String nextPageToken);

        /**
         * <p>
         * Enables you to customize recommendations across two attributes. You can choose to view recommendations for
         * instances within the same instance families or across different instance families. You can also choose to
         * view your estimated savings associated with recommendations with consideration of existing Savings Plans or
         * RI benefits, or neither.
         * </p>
         * 
         * @param configuration
         *        Enables you to customize recommendations across two attributes. You can choose to view recommendations
         *        for instances within the same instance families or across different instance families. You can also
         *        choose to view your estimated savings associated with recommendations with consideration of existing
         *        Savings Plans or RI benefits, or neither.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configuration(RightsizingRecommendationConfiguration configuration);

        /**
         * <p>
         * Enables you to customize recommendations across two attributes. You can choose to view recommendations for
         * instances within the same instance families or across different instance families. You can also choose to
         * view your estimated savings associated with recommendations with consideration of existing Savings Plans or
         * RI benefits, or neither.
         * </p>
         * This is a convenience that creates an instance of the {@link RightsizingRecommendationConfiguration.Builder}
         * avoiding the need to create one manually via {@link RightsizingRecommendationConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RightsizingRecommendationConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #configuration(RightsizingRecommendationConfiguration)}.
         * 
         * @param configuration
         *        a consumer that will call methods on {@link RightsizingRecommendationConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #configuration(RightsizingRecommendationConfiguration)
         */
        default Builder configuration(Consumer<RightsizingRecommendationConfiguration.Builder> configuration) {
            return configuration(RightsizingRecommendationConfiguration.builder().applyMutation(configuration).build());
        }
    }

    static final class BuilderImpl extends CostExplorerResponse.BuilderImpl implements Builder {
        private RightsizingRecommendationMetadata metadata;

        private RightsizingRecommendationSummary summary;

        private List<RightsizingRecommendation> rightsizingRecommendations = DefaultSdkAutoConstructList.getInstance();

        private String nextPageToken;

        private RightsizingRecommendationConfiguration configuration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRightsizingRecommendationResponse model) {
            super(model);
            metadata(model.metadata);
            summary(model.summary);
            rightsizingRecommendations(model.rightsizingRecommendations);
            nextPageToken(model.nextPageToken);
            configuration(model.configuration);
        }

        public final RightsizingRecommendationMetadata.Builder getMetadata() {
            return metadata != null ? metadata.toBuilder() : null;
        }

        @Override
        public final Builder metadata(RightsizingRecommendationMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public final void setMetadata(RightsizingRecommendationMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        public final RightsizingRecommendationSummary.Builder getSummary() {
            return summary != null ? summary.toBuilder() : null;
        }

        @Override
        public final Builder summary(RightsizingRecommendationSummary summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(RightsizingRecommendationSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        public final List<RightsizingRecommendation.Builder> getRightsizingRecommendations() {
            List<RightsizingRecommendation.Builder> result = RightsizingRecommendationListCopier
                    .copyToBuilder(this.rightsizingRecommendations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder rightsizingRecommendations(Collection<RightsizingRecommendation> rightsizingRecommendations) {
            this.rightsizingRecommendations = RightsizingRecommendationListCopier.copy(rightsizingRecommendations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rightsizingRecommendations(RightsizingRecommendation... rightsizingRecommendations) {
            rightsizingRecommendations(Arrays.asList(rightsizingRecommendations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rightsizingRecommendations(Consumer<RightsizingRecommendation.Builder>... rightsizingRecommendations) {
            rightsizingRecommendations(Stream.of(rightsizingRecommendations)
                    .map(c -> RightsizingRecommendation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRightsizingRecommendations(
                Collection<RightsizingRecommendation.BuilderImpl> rightsizingRecommendations) {
            this.rightsizingRecommendations = RightsizingRecommendationListCopier.copyFromBuilder(rightsizingRecommendations);
        }

        public final String getNextPageToken() {
            return nextPageToken;
        }

        @Override
        public final Builder nextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
            return this;
        }

        public final void setNextPageToken(String nextPageToken) {
            this.nextPageToken = nextPageToken;
        }

        public final RightsizingRecommendationConfiguration.Builder getConfiguration() {
            return configuration != null ? configuration.toBuilder() : null;
        }

        @Override
        public final Builder configuration(RightsizingRecommendationConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final void setConfiguration(RightsizingRecommendationConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public GetRightsizingRecommendationResponse build() {
            return new GetRightsizingRecommendationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
