/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.costexplorer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A reference to a Cost Category containing only enough information to identify the Cost Category.
 * </p>
 * <p>
 * You can use this information to retrieve the full Cost Category information using <code>DescribeCostCategory</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CostCategoryReference implements SdkPojo, Serializable,
        ToCopyableBuilder<CostCategoryReference.Builder, CostCategoryReference> {
    private static final SdkField<String> COST_CATEGORY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CostCategoryArn").getter(getter(CostCategoryReference::costCategoryArn))
            .setter(setter(Builder::costCategoryArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostCategoryArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CostCategoryReference::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> EFFECTIVE_START_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EffectiveStart").getter(getter(CostCategoryReference::effectiveStart))
            .setter(setter(Builder::effectiveStart))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveStart").build()).build();

    private static final SdkField<String> EFFECTIVE_END_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EffectiveEnd").getter(getter(CostCategoryReference::effectiveEnd)).setter(setter(Builder::effectiveEnd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveEnd").build()).build();

    private static final SdkField<Integer> NUMBER_OF_RULES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfRules").getter(getter(CostCategoryReference::numberOfRules))
            .setter(setter(Builder::numberOfRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfRules").build()).build();

    private static final SdkField<List<CostCategoryProcessingStatus>> PROCESSING_STATUS_FIELD = SdkField
            .<List<CostCategoryProcessingStatus>> builder(MarshallingType.LIST)
            .memberName("ProcessingStatus")
            .getter(getter(CostCategoryReference::processingStatus))
            .setter(setter(Builder::processingStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CostCategoryProcessingStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(CostCategoryProcessingStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Values")
            .getter(getter(CostCategoryReference::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue").getter(getter(CostCategoryReference::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_CATEGORY_ARN_FIELD,
            NAME_FIELD, EFFECTIVE_START_FIELD, EFFECTIVE_END_FIELD, NUMBER_OF_RULES_FIELD, PROCESSING_STATUS_FIELD, VALUES_FIELD,
            DEFAULT_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String costCategoryArn;

    private final String name;

    private final String effectiveStart;

    private final String effectiveEnd;

    private final Integer numberOfRules;

    private final List<CostCategoryProcessingStatus> processingStatus;

    private final List<String> values;

    private final String defaultValue;

    private CostCategoryReference(BuilderImpl builder) {
        this.costCategoryArn = builder.costCategoryArn;
        this.name = builder.name;
        this.effectiveStart = builder.effectiveStart;
        this.effectiveEnd = builder.effectiveEnd;
        this.numberOfRules = builder.numberOfRules;
        this.processingStatus = builder.processingStatus;
        this.values = builder.values;
        this.defaultValue = builder.defaultValue;
    }

    /**
     * <p>
     * The unique identifier for your Cost Category.
     * </p>
     * 
     * @return The unique identifier for your Cost Category.
     */
    public final String costCategoryArn() {
        return costCategoryArn;
    }

    /**
     * Returns the value of the Name property for this object.
     * 
     * @return The value of the Name property for this object.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The Cost Category's effective start date.
     * </p>
     * 
     * @return The Cost Category's effective start date.
     */
    public final String effectiveStart() {
        return effectiveStart;
    }

    /**
     * <p>
     * The Cost Category's effective end date.
     * </p>
     * 
     * @return The Cost Category's effective end date.
     */
    public final String effectiveEnd() {
        return effectiveEnd;
    }

    /**
     * <p>
     * The number of rules associated with a specific Cost Category.
     * </p>
     * 
     * @return The number of rules associated with a specific Cost Category.
     */
    public final Integer numberOfRules() {
        return numberOfRules;
    }

    /**
     * Returns true if the ProcessingStatus property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasProcessingStatus() {
        return processingStatus != null && !(processingStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of processing statuses for Cost Management products for a specific cost category.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasProcessingStatus()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of processing statuses for Cost Management products for a specific cost category.
     */
    public final List<CostCategoryProcessingStatus> processingStatus() {
        return processingStatus;
    }

    /**
     * Returns true if the Values property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of unique cost category values in a specific cost category.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of unique cost category values in a specific cost category.
     */
    public final List<String> values() {
        return values;
    }

    /**
     * Returns the value of the DefaultValue property for this object.
     * 
     * @return The value of the DefaultValue property for this object.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(costCategoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveStart());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveEnd());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfRules());
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessingStatus() ? processingStatus() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CostCategoryReference)) {
            return false;
        }
        CostCategoryReference other = (CostCategoryReference) obj;
        return Objects.equals(costCategoryArn(), other.costCategoryArn()) && Objects.equals(name(), other.name())
                && Objects.equals(effectiveStart(), other.effectiveStart())
                && Objects.equals(effectiveEnd(), other.effectiveEnd()) && Objects.equals(numberOfRules(), other.numberOfRules())
                && hasProcessingStatus() == other.hasProcessingStatus()
                && Objects.equals(processingStatus(), other.processingStatus()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values()) && Objects.equals(defaultValue(), other.defaultValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CostCategoryReference").add("CostCategoryArn", costCategoryArn()).add("Name", name())
                .add("EffectiveStart", effectiveStart()).add("EffectiveEnd", effectiveEnd())
                .add("NumberOfRules", numberOfRules()).add("ProcessingStatus", hasProcessingStatus() ? processingStatus() : null)
                .add("Values", hasValues() ? values() : null).add("DefaultValue", defaultValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CostCategoryArn":
            return Optional.ofNullable(clazz.cast(costCategoryArn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "EffectiveStart":
            return Optional.ofNullable(clazz.cast(effectiveStart()));
        case "EffectiveEnd":
            return Optional.ofNullable(clazz.cast(effectiveEnd()));
        case "NumberOfRules":
            return Optional.ofNullable(clazz.cast(numberOfRules()));
        case "ProcessingStatus":
            return Optional.ofNullable(clazz.cast(processingStatus()));
        case "Values":
            return Optional.ofNullable(clazz.cast(values()));
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CostCategoryReference, T> g) {
        return obj -> g.apply((CostCategoryReference) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CostCategoryReference> {
        /**
         * <p>
         * The unique identifier for your Cost Category.
         * </p>
         * 
         * @param costCategoryArn
         *        The unique identifier for your Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder costCategoryArn(String costCategoryArn);

        /**
         * Sets the value of the Name property for this object.
         *
         * @param name
         *        The new value for the Name property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The Cost Category's effective start date.
         * </p>
         * 
         * @param effectiveStart
         *        The Cost Category's effective start date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveStart(String effectiveStart);

        /**
         * <p>
         * The Cost Category's effective end date.
         * </p>
         * 
         * @param effectiveEnd
         *        The Cost Category's effective end date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveEnd(String effectiveEnd);

        /**
         * <p>
         * The number of rules associated with a specific Cost Category.
         * </p>
         * 
         * @param numberOfRules
         *        The number of rules associated with a specific Cost Category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfRules(Integer numberOfRules);

        /**
         * <p>
         * The list of processing statuses for Cost Management products for a specific cost category.
         * </p>
         * 
         * @param processingStatus
         *        The list of processing statuses for Cost Management products for a specific cost category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingStatus(Collection<CostCategoryProcessingStatus> processingStatus);

        /**
         * <p>
         * The list of processing statuses for Cost Management products for a specific cost category.
         * </p>
         * 
         * @param processingStatus
         *        The list of processing statuses for Cost Management products for a specific cost category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processingStatus(CostCategoryProcessingStatus... processingStatus);

        /**
         * <p>
         * The list of processing statuses for Cost Management products for a specific cost category.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CostCategoryProcessingStatus>.Builder}
         * avoiding the need to create one manually via {@link List<CostCategoryProcessingStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CostCategoryProcessingStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link #processingStatus(List<CostCategoryProcessingStatus>)}.
         * 
         * @param processingStatus
         *        a consumer that will call methods on {@link List<CostCategoryProcessingStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processingStatus(List<CostCategoryProcessingStatus>)
         */
        Builder processingStatus(Consumer<CostCategoryProcessingStatus.Builder>... processingStatus);

        /**
         * <p>
         * A list of unique cost category values in a specific cost category.
         * </p>
         * 
         * @param values
         *        A list of unique cost category values in a specific cost category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * A list of unique cost category values in a specific cost category.
         * </p>
         * 
         * @param values
         *        A list of unique cost category values in a specific cost category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);

        /**
         * Sets the value of the DefaultValue property for this object.
         *
         * @param defaultValue
         *        The new value for the DefaultValue property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);
    }

    static final class BuilderImpl implements Builder {
        private String costCategoryArn;

        private String name;

        private String effectiveStart;

        private String effectiveEnd;

        private Integer numberOfRules;

        private List<CostCategoryProcessingStatus> processingStatus = DefaultSdkAutoConstructList.getInstance();

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private String defaultValue;

        private BuilderImpl() {
        }

        private BuilderImpl(CostCategoryReference model) {
            costCategoryArn(model.costCategoryArn);
            name(model.name);
            effectiveStart(model.effectiveStart);
            effectiveEnd(model.effectiveEnd);
            numberOfRules(model.numberOfRules);
            processingStatus(model.processingStatus);
            values(model.values);
            defaultValue(model.defaultValue);
        }

        public final String getCostCategoryArn() {
            return costCategoryArn;
        }

        @Override
        public final Builder costCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
            return this;
        }

        public final void setCostCategoryArn(String costCategoryArn) {
            this.costCategoryArn = costCategoryArn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getEffectiveStart() {
            return effectiveStart;
        }

        @Override
        public final Builder effectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
            return this;
        }

        public final void setEffectiveStart(String effectiveStart) {
            this.effectiveStart = effectiveStart;
        }

        public final String getEffectiveEnd() {
            return effectiveEnd;
        }

        @Override
        public final Builder effectiveEnd(String effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
            return this;
        }

        public final void setEffectiveEnd(String effectiveEnd) {
            this.effectiveEnd = effectiveEnd;
        }

        public final Integer getNumberOfRules() {
            return numberOfRules;
        }

        @Override
        public final Builder numberOfRules(Integer numberOfRules) {
            this.numberOfRules = numberOfRules;
            return this;
        }

        public final void setNumberOfRules(Integer numberOfRules) {
            this.numberOfRules = numberOfRules;
        }

        public final List<CostCategoryProcessingStatus.Builder> getProcessingStatus() {
            List<CostCategoryProcessingStatus.Builder> result = CostCategoryProcessingStatusListCopier
                    .copyToBuilder(this.processingStatus);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder processingStatus(Collection<CostCategoryProcessingStatus> processingStatus) {
            this.processingStatus = CostCategoryProcessingStatusListCopier.copy(processingStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingStatus(CostCategoryProcessingStatus... processingStatus) {
            processingStatus(Arrays.asList(processingStatus));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processingStatus(Consumer<CostCategoryProcessingStatus.Builder>... processingStatus) {
            processingStatus(Stream.of(processingStatus)
                    .map(c -> CostCategoryProcessingStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProcessingStatus(Collection<CostCategoryProcessingStatus.BuilderImpl> processingStatus) {
            this.processingStatus = CostCategoryProcessingStatusListCopier.copyFromBuilder(processingStatus);
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = CostCategoryValuesListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<String> values) {
            this.values = CostCategoryValuesListCopier.copy(values);
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public CostCategoryReference build() {
            return new CostCategoryReference(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
