/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codepipeline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ActionContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ActionContext> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActionContext.getter(ActionContext::name)).setter(ActionContext.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ACTION_EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ActionContext.getter(ActionContext::actionExecutionId)).setter(ActionContext.setter(Builder::actionExecutionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionExecutionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, ACTION_EXECUTION_ID_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String actionExecutionId;

    private ActionContext(BuilderImpl builder) {
        this.name = builder.name;
        this.actionExecutionId = builder.actionExecutionId;
    }

    public String name() {
        return this.name;
    }

    public String actionExecutionId() {
        return this.actionExecutionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionExecutionId());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionContext)) {
            return false;
        }
        ActionContext other = (ActionContext)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.actionExecutionId(), other.actionExecutionId());
    }

    public String toString() {
        return ToString.builder((String)"ActionContext").add("Name", (Object)this.name()).add("ActionExecutionId", (Object)this.actionExecutionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "actionExecutionId": {
                return Optional.ofNullable(clazz.cast(this.actionExecutionId()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ActionContext, T> g) {
        return obj -> g.apply((ActionContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String actionExecutionId;

        private BuilderImpl() {
        }

        private BuilderImpl(ActionContext model) {
            this.name(model.name);
            this.actionExecutionId(model.actionExecutionId);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getActionExecutionId() {
            return this.actionExecutionId;
        }

        @Override
        public final Builder actionExecutionId(String actionExecutionId) {
            this.actionExecutionId = actionExecutionId;
            return this;
        }

        public final void setActionExecutionId(String actionExecutionId) {
            this.actionExecutionId = actionExecutionId;
        }

        public ActionContext build() {
            return new ActionContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ActionContext> {
        public Builder name(String var1);

        public Builder actionExecutionId(String var1);
    }
}

