/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codebuild.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.codebuild.CodeBuildAsyncClient;
import software.amazon.awssdk.services.codebuild.model.CodeCoverage;
import software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesRequest;
import software.amazon.awssdk.services.codebuild.model.DescribeCodeCoveragesResponse;

public class DescribeCodeCoveragesPublisher
implements SdkPublisher<DescribeCodeCoveragesResponse> {
    private final CodeBuildAsyncClient client;
    private final DescribeCodeCoveragesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCodeCoveragesPublisher(CodeBuildAsyncClient client, DescribeCodeCoveragesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCodeCoveragesPublisher(CodeBuildAsyncClient client, DescribeCodeCoveragesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCodeCoveragesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCodeCoveragesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CodeCoverage> codeCoverages() {
        Function<DescribeCodeCoveragesResponse, Iterator> getIterator = response -> {
            if (response != null && response.codeCoverages() != null) {
                return response.codeCoverages().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCodeCoveragesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCodeCoveragesResponseFetcher
    implements AsyncPageFetcher<DescribeCodeCoveragesResponse> {
        private DescribeCodeCoveragesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCodeCoveragesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeCodeCoveragesResponse> nextPage(DescribeCodeCoveragesResponse previousPage) {
            if (previousPage == null) {
                return DescribeCodeCoveragesPublisher.this.client.describeCodeCoverages(DescribeCodeCoveragesPublisher.this.firstRequest);
            }
            return DescribeCodeCoveragesPublisher.this.client.describeCodeCoverages((DescribeCodeCoveragesRequest)((Object)DescribeCodeCoveragesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

