/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the unmodified data for the report. For more information, see .
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ReportWithRawData implements SdkPojo, Serializable,
        ToCopyableBuilder<ReportWithRawData.Builder, ReportWithRawData> {
    private static final SdkField<String> REPORT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("reportArn").getter(getter(ReportWithRawData::reportArn)).setter(setter(Builder::reportArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportArn").build()).build();

    private static final SdkField<String> DATA_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("data")
            .getter(getter(ReportWithRawData::data)).setter(setter(Builder::data))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("data").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPORT_ARN_FIELD, DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String reportArn;

    private final String data;

    private ReportWithRawData(BuilderImpl builder) {
        this.reportArn = builder.reportArn;
        this.data = builder.data;
    }

    /**
     * <p>
     * The ARN of the report.
     * </p>
     * 
     * @return The ARN of the report.
     */
    public final String reportArn() {
        return reportArn;
    }

    /**
     * <p>
     * The value of the requested data field from the report.
     * </p>
     * 
     * @return The value of the requested data field from the report.
     */
    public final String data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(reportArn());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportWithRawData)) {
            return false;
        }
        ReportWithRawData other = (ReportWithRawData) obj;
        return Objects.equals(reportArn(), other.reportArn()) && Objects.equals(data(), other.data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ReportWithRawData").add("ReportArn", reportArn()).add("Data", data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "reportArn":
            return Optional.ofNullable(clazz.cast(reportArn()));
        case "data":
            return Optional.ofNullable(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ReportWithRawData, T> g) {
        return obj -> g.apply((ReportWithRawData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ReportWithRawData> {
        /**
         * <p>
         * The ARN of the report.
         * </p>
         * 
         * @param reportArn
         *        The ARN of the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportArn(String reportArn);

        /**
         * <p>
         * The value of the requested data field from the report.
         * </p>
         * 
         * @param data
         *        The value of the requested data field from the report.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(String data);
    }

    static final class BuilderImpl implements Builder {
        private String reportArn;

        private String data;

        private BuilderImpl() {
        }

        private BuilderImpl(ReportWithRawData model) {
            reportArn(model.reportArn);
            data(model.data);
        }

        public final String getReportArn() {
            return reportArn;
        }

        @Override
        public final Builder reportArn(String reportArn) {
            this.reportArn = reportArn;
            return this;
        }

        public final void setReportArn(String reportArn) {
            this.reportArn = reportArn;
        }

        public final String getData() {
            return data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final void setData(String data) {
            this.data = data;
        }

        @Override
        public ReportWithRawData build() {
            return new ReportWithRawData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
