/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codebuild.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A set of Docker images that are related by programming language and are managed by AWS CodeBuild.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EnvironmentLanguage implements SdkPojo, Serializable,
        ToCopyableBuilder<EnvironmentLanguage.Builder, EnvironmentLanguage> {
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("language").getter(getter(EnvironmentLanguage::languageAsString)).setter(setter(Builder::language))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()).build();

    private static final SdkField<List<EnvironmentImage>> IMAGES_FIELD = SdkField
            .<List<EnvironmentImage>> builder(MarshallingType.LIST)
            .memberName("images")
            .getter(getter(EnvironmentLanguage::images))
            .setter(setter(Builder::images))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("images").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EnvironmentImage> builder(MarshallingType.SDK_POJO)
                                            .constructor(EnvironmentImage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LANGUAGE_FIELD, IMAGES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String language;

    private final List<EnvironmentImage> images;

    private EnvironmentLanguage(BuilderImpl builder) {
        this.language = builder.language;
        this.images = builder.images;
    }

    /**
     * <p>
     * The programming language for the Docker images.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link LanguageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageAsString}.
     * </p>
     * 
     * @return The programming language for the Docker images.
     * @see LanguageType
     */
    public final LanguageType language() {
        return LanguageType.fromValue(language);
    }

    /**
     * <p>
     * The programming language for the Docker images.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #language} will
     * return {@link LanguageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #languageAsString}.
     * </p>
     * 
     * @return The programming language for the Docker images.
     * @see LanguageType
     */
    public final String languageAsString() {
        return language;
    }

    /**
     * Returns true if the Images property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasImages() {
        return images != null && !(images instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Docker images that are related by the specified programming language.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasImages()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of Docker images that are related by the specified programming language.
     */
    public final List<EnvironmentImage> images() {
        return images;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(languageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasImages() ? images() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentLanguage)) {
            return false;
        }
        EnvironmentLanguage other = (EnvironmentLanguage) obj;
        return Objects.equals(languageAsString(), other.languageAsString()) && hasImages() == other.hasImages()
                && Objects.equals(images(), other.images());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EnvironmentLanguage").add("Language", languageAsString())
                .add("Images", hasImages() ? images() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "language":
            return Optional.ofNullable(clazz.cast(languageAsString()));
        case "images":
            return Optional.ofNullable(clazz.cast(images()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentLanguage, T> g) {
        return obj -> g.apply((EnvironmentLanguage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EnvironmentLanguage> {
        /**
         * <p>
         * The programming language for the Docker images.
         * </p>
         * 
         * @param language
         *        The programming language for the Docker images.
         * @see LanguageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageType
         */
        Builder language(String language);

        /**
         * <p>
         * The programming language for the Docker images.
         * </p>
         * 
         * @param language
         *        The programming language for the Docker images.
         * @see LanguageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LanguageType
         */
        Builder language(LanguageType language);

        /**
         * <p>
         * The list of Docker images that are related by the specified programming language.
         * </p>
         * 
         * @param images
         *        The list of Docker images that are related by the specified programming language.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(Collection<EnvironmentImage> images);

        /**
         * <p>
         * The list of Docker images that are related by the specified programming language.
         * </p>
         * 
         * @param images
         *        The list of Docker images that are related by the specified programming language.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(EnvironmentImage... images);

        /**
         * <p>
         * The list of Docker images that are related by the specified programming language.
         * </p>
         * This is a convenience that creates an instance of the {@link List<EnvironmentImage>.Builder} avoiding the
         * need to create one manually via {@link List<EnvironmentImage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<EnvironmentImage>.Builder#build()} is called immediately and
         * its result is passed to {@link #images(List<EnvironmentImage>)}.
         * 
         * @param images
         *        a consumer that will call methods on {@link List<EnvironmentImage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #images(List<EnvironmentImage>)
         */
        Builder images(Consumer<EnvironmentImage.Builder>... images);
    }

    static final class BuilderImpl implements Builder {
        private String language;

        private List<EnvironmentImage> images = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentLanguage model) {
            language(model.language);
            images(model.images);
        }

        public final String getLanguage() {
            return language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        @Override
        public final Builder language(LanguageType language) {
            this.language(language == null ? null : language.toString());
            return this;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        public final List<EnvironmentImage.Builder> getImages() {
            List<EnvironmentImage.Builder> result = EnvironmentImagesCopier.copyToBuilder(this.images);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder images(Collection<EnvironmentImage> images) {
            this.images = EnvironmentImagesCopier.copy(images);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(EnvironmentImage... images) {
            images(Arrays.asList(images));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder images(Consumer<EnvironmentImage.Builder>... images) {
            images(Stream.of(images).map(c -> EnvironmentImage.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setImages(Collection<EnvironmentImage.BuilderImpl> images) {
            this.images = EnvironmentImagesCopier.copyFromBuilder(images);
        }

        @Override
        public EnvironmentLanguage build() {
            return new EnvironmentLanguage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
