/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cleanroomsml;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlClient;
import software.amazon.awssdk.services.cleanroomsml.CleanRoomsMlServiceClientConfiguration;
import software.amazon.awssdk.services.cleanroomsml.internal.CleanRoomsMlServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cleanroomsml.model.AccessDeniedException;
import software.amazon.awssdk.services.cleanroomsml.model.CleanRoomsMlException;
import software.amazon.awssdk.services.cleanroomsml.model.ConflictException;
import software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.CreateTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.DeleteTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetRequest;
import software.amazon.awssdk.services.cleanroomsml.model.GetTrainingDatasetResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceExportJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceGenerationJobsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListAudienceModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListConfiguredAudienceModelsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsRequest;
import software.amazon.awssdk.services.cleanroomsml.model.ListTrainingDatasetsResponse;
import software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyRequest;
import software.amazon.awssdk.services.cleanroomsml.model.PutConfiguredAudienceModelPolicyResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cleanroomsml.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceExportJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobRequest;
import software.amazon.awssdk.services.cleanroomsml.model.StartAudienceGenerationJobResponse;
import software.amazon.awssdk.services.cleanroomsml.model.TagResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.TagResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.UntagResourceRequest;
import software.amazon.awssdk.services.cleanroomsml.model.UntagResourceResponse;
import software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelRequest;
import software.amazon.awssdk.services.cleanroomsml.model.UpdateConfiguredAudienceModelResponse;
import software.amazon.awssdk.services.cleanroomsml.model.ValidationException;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateConfiguredAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.CreateTrainingDatasetRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteAudienceGenerationJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteConfiguredAudienceModelPolicyRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteConfiguredAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.DeleteTrainingDatasetRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetAudienceGenerationJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetConfiguredAudienceModelPolicyRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetConfiguredAudienceModelRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.GetTrainingDatasetRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListAudienceExportJobsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListAudienceGenerationJobsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListAudienceModelsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListConfiguredAudienceModelsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.ListTrainingDatasetsRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.PutConfiguredAudienceModelPolicyRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.StartAudienceExportJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.StartAudienceGenerationJobRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cleanroomsml.transform.UpdateConfiguredAudienceModelRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCleanRoomsMlClient
implements CleanRoomsMlClient {
    private static final Logger log = Logger.loggerFor(DefaultCleanRoomsMlClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.REST_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCleanRoomsMlClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAudienceModelResponse createAudienceModel(CreateAudienceModelRequest createAudienceModelRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAudienceModelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createAudienceModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, createAudienceModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAudienceModel");
            CreateAudienceModelResponse createAudienceModelResponse = (CreateAudienceModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAudienceModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createAudienceModelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateAudienceModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAudienceModelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$createAudienceModel$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateConfiguredAudienceModelResponse createConfiguredAudienceModel(CreateConfiguredAudienceModelRequest createConfiguredAudienceModelRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateConfiguredAudienceModelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createConfiguredAudienceModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, createConfiguredAudienceModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateConfiguredAudienceModel");
            CreateConfiguredAudienceModelResponse createConfiguredAudienceModelResponse = (CreateConfiguredAudienceModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateConfiguredAudienceModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createConfiguredAudienceModelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateConfiguredAudienceModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createConfiguredAudienceModelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$createConfiguredAudienceModel$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTrainingDatasetResponse createTrainingDataset(CreateTrainingDatasetRequest createTrainingDatasetRequest) throws ConflictException, ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTrainingDatasetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTrainingDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, createTrainingDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTrainingDataset");
            CreateTrainingDatasetResponse createTrainingDatasetResponse = (CreateTrainingDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrainingDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTrainingDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTrainingDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTrainingDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$createTrainingDataset$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAudienceGenerationJobResponse deleteAudienceGenerationJob(DeleteAudienceGenerationJobRequest deleteAudienceGenerationJobRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAudienceGenerationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAudienceGenerationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, deleteAudienceGenerationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAudienceGenerationJob");
            DeleteAudienceGenerationJobResponse deleteAudienceGenerationJobResponse = (DeleteAudienceGenerationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAudienceGenerationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAudienceGenerationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAudienceGenerationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAudienceGenerationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$deleteAudienceGenerationJob$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAudienceModelResponse deleteAudienceModel(DeleteAudienceModelRequest deleteAudienceModelRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAudienceModelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteAudienceModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, deleteAudienceModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAudienceModel");
            DeleteAudienceModelResponse deleteAudienceModelResponse = (DeleteAudienceModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAudienceModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteAudienceModelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAudienceModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAudienceModelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$deleteAudienceModel$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConfiguredAudienceModelResponse deleteConfiguredAudienceModel(DeleteConfiguredAudienceModelRequest deleteConfiguredAudienceModelRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfiguredAudienceModelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConfiguredAudienceModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, deleteConfiguredAudienceModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfiguredAudienceModel");
            DeleteConfiguredAudienceModelResponse deleteConfiguredAudienceModelResponse = (DeleteConfiguredAudienceModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfiguredAudienceModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteConfiguredAudienceModelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConfiguredAudienceModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConfiguredAudienceModelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$deleteConfiguredAudienceModel$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteConfiguredAudienceModelPolicyResponse deleteConfiguredAudienceModelPolicy(DeleteConfiguredAudienceModelPolicyRequest deleteConfiguredAudienceModelPolicyRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteConfiguredAudienceModelPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteConfiguredAudienceModelPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, deleteConfiguredAudienceModelPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteConfiguredAudienceModelPolicy");
            DeleteConfiguredAudienceModelPolicyResponse deleteConfiguredAudienceModelPolicyResponse = (DeleteConfiguredAudienceModelPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteConfiguredAudienceModelPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteConfiguredAudienceModelPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteConfiguredAudienceModelPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteConfiguredAudienceModelPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$deleteConfiguredAudienceModelPolicy$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTrainingDatasetResponse deleteTrainingDataset(DeleteTrainingDatasetRequest deleteTrainingDatasetRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTrainingDatasetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTrainingDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, deleteTrainingDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTrainingDataset");
            DeleteTrainingDatasetResponse deleteTrainingDatasetResponse = (DeleteTrainingDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrainingDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTrainingDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTrainingDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTrainingDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$deleteTrainingDataset$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAudienceGenerationJobResponse getAudienceGenerationJob(GetAudienceGenerationJobRequest getAudienceGenerationJobRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAudienceGenerationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAudienceGenerationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, getAudienceGenerationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAudienceGenerationJob");
            GetAudienceGenerationJobResponse getAudienceGenerationJobResponse = (GetAudienceGenerationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAudienceGenerationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAudienceGenerationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAudienceGenerationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAudienceGenerationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$getAudienceGenerationJob$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAudienceModelResponse getAudienceModel(GetAudienceModelRequest getAudienceModelRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAudienceModelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getAudienceModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, getAudienceModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAudienceModel");
            GetAudienceModelResponse getAudienceModelResponse = (GetAudienceModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAudienceModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getAudienceModelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetAudienceModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAudienceModelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$getAudienceModel$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetConfiguredAudienceModelResponse getConfiguredAudienceModel(GetConfiguredAudienceModelRequest getConfiguredAudienceModelRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConfiguredAudienceModelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getConfiguredAudienceModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, getConfiguredAudienceModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConfiguredAudienceModel");
            GetConfiguredAudienceModelResponse getConfiguredAudienceModelResponse = (GetConfiguredAudienceModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConfiguredAudienceModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getConfiguredAudienceModelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetConfiguredAudienceModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getConfiguredAudienceModelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$getConfiguredAudienceModel$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetConfiguredAudienceModelPolicyResponse getConfiguredAudienceModelPolicy(GetConfiguredAudienceModelPolicyRequest getConfiguredAudienceModelPolicyRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetConfiguredAudienceModelPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getConfiguredAudienceModelPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, getConfiguredAudienceModelPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetConfiguredAudienceModelPolicy");
            GetConfiguredAudienceModelPolicyResponse getConfiguredAudienceModelPolicyResponse = (GetConfiguredAudienceModelPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetConfiguredAudienceModelPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getConfiguredAudienceModelPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetConfiguredAudienceModelPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getConfiguredAudienceModelPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$getConfiguredAudienceModelPolicy$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTrainingDatasetResponse getTrainingDataset(GetTrainingDatasetRequest getTrainingDatasetRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTrainingDatasetResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTrainingDatasetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, getTrainingDatasetRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTrainingDataset");
            GetTrainingDatasetResponse getTrainingDatasetResponse = (GetTrainingDatasetResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrainingDataset").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTrainingDatasetRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTrainingDatasetRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTrainingDatasetResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$getTrainingDataset$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAudienceExportJobsResponse listAudienceExportJobs(ListAudienceExportJobsRequest listAudienceExportJobsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAudienceExportJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAudienceExportJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, listAudienceExportJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAudienceExportJobs");
            ListAudienceExportJobsResponse listAudienceExportJobsResponse = (ListAudienceExportJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAudienceExportJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAudienceExportJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAudienceExportJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAudienceExportJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$listAudienceExportJobs$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAudienceGenerationJobsResponse listAudienceGenerationJobs(ListAudienceGenerationJobsRequest listAudienceGenerationJobsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAudienceGenerationJobsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAudienceGenerationJobsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, listAudienceGenerationJobsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAudienceGenerationJobs");
            ListAudienceGenerationJobsResponse listAudienceGenerationJobsResponse = (ListAudienceGenerationJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAudienceGenerationJobs").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAudienceGenerationJobsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAudienceGenerationJobsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAudienceGenerationJobsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$listAudienceGenerationJobs$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAudienceModelsResponse listAudienceModels(ListAudienceModelsRequest listAudienceModelsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAudienceModelsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listAudienceModelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, listAudienceModelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAudienceModels");
            ListAudienceModelsResponse listAudienceModelsResponse = (ListAudienceModelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAudienceModels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listAudienceModelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListAudienceModelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAudienceModelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$listAudienceModels$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListConfiguredAudienceModelsResponse listConfiguredAudienceModels(ListConfiguredAudienceModelsRequest listConfiguredAudienceModelsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListConfiguredAudienceModelsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listConfiguredAudienceModelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, listConfiguredAudienceModelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListConfiguredAudienceModels");
            ListConfiguredAudienceModelsResponse listConfiguredAudienceModelsResponse = (ListConfiguredAudienceModelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListConfiguredAudienceModels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listConfiguredAudienceModelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListConfiguredAudienceModelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listConfiguredAudienceModelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$listConfiguredAudienceModels$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTagsForResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$listTagsForResource$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTrainingDatasetsResponse listTrainingDatasets(ListTrainingDatasetsRequest listTrainingDatasetsRequest) throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTrainingDatasetsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listTrainingDatasetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, listTrainingDatasetsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTrainingDatasets");
            ListTrainingDatasetsResponse listTrainingDatasetsResponse = (ListTrainingDatasetsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTrainingDatasets").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listTrainingDatasetsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTrainingDatasetsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTrainingDatasetsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$listTrainingDatasets$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutConfiguredAudienceModelPolicyResponse putConfiguredAudienceModelPolicy(PutConfiguredAudienceModelPolicyRequest putConfiguredAudienceModelPolicyRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutConfiguredAudienceModelPolicyResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putConfiguredAudienceModelPolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, putConfiguredAudienceModelPolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutConfiguredAudienceModelPolicy");
            PutConfiguredAudienceModelPolicyResponse putConfiguredAudienceModelPolicyResponse = (PutConfiguredAudienceModelPolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutConfiguredAudienceModelPolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putConfiguredAudienceModelPolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutConfiguredAudienceModelPolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putConfiguredAudienceModelPolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$putConfiguredAudienceModelPolicy$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartAudienceExportJobResponse startAudienceExportJob(StartAudienceExportJobRequest startAudienceExportJobRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartAudienceExportJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startAudienceExportJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, startAudienceExportJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartAudienceExportJob");
            StartAudienceExportJobResponse startAudienceExportJobResponse = (StartAudienceExportJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartAudienceExportJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startAudienceExportJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartAudienceExportJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startAudienceExportJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$startAudienceExportJob$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartAudienceGenerationJobResponse startAudienceGenerationJob(StartAudienceGenerationJobRequest startAudienceGenerationJobRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartAudienceGenerationJobResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)startAudienceGenerationJobRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, startAudienceGenerationJobRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartAudienceGenerationJob");
            StartAudienceGenerationJobResponse startAudienceGenerationJobResponse = (StartAudienceGenerationJobResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartAudienceGenerationJob").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)startAudienceGenerationJobRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartAudienceGenerationJobRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startAudienceGenerationJobResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$startAudienceGenerationJob$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$tagResource$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$untagResource$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateConfiguredAudienceModelResponse updateConfiguredAudienceModel(UpdateConfiguredAudienceModelRequest updateConfiguredAudienceModelRequest) throws ConflictException, ValidationException, AccessDeniedException, ResourceNotFoundException, AwsServiceException, SdkClientException, CleanRoomsMlException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateConfiguredAudienceModelResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)updateConfiguredAudienceModelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCleanRoomsMlClient.resolveMetricPublishers(clientConfiguration, updateConfiguredAudienceModelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CleanRoomsML");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateConfiguredAudienceModel");
            UpdateConfiguredAudienceModelResponse updateConfiguredAudienceModelResponse = (UpdateConfiguredAudienceModelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateConfiguredAudienceModel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)updateConfiguredAudienceModelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateConfiguredAudienceModelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateConfiguredAudienceModelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCleanRoomsMlClient.lambda$updateConfiguredAudienceModel$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "cleanrooms-ml";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)AwsRetryStrategy.forRetryMode((RetryMode)retryMode));
        } else {
            Consumer configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option((ClientOption)SdkClientOption.RETRY_STRATEGY, (Object)retryStrategy);
                }
            }
        }
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option((ClientOption)SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        CleanRoomsMlServiceClientConfigurationBuilder serviceConfigBuilder = new CleanRoomsMlServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        this.updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CleanRoomsMlException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build());
    }

    @Override
    public final CleanRoomsMlServiceClientConfiguration serviceClientConfiguration() {
        return new CleanRoomsMlServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateConfiguredAudienceModel$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startAudienceGenerationJob$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startAudienceExportJob$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putConfiguredAudienceModelPolicy$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTrainingDatasets$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listConfiguredAudienceModels$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAudienceModels$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAudienceGenerationJobs$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listAudienceExportJobs$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getTrainingDataset$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConfiguredAudienceModelPolicy$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getConfiguredAudienceModel$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAudienceModel$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getAudienceGenerationJob$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteTrainingDataset$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConfiguredAudienceModelPolicy$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteConfiguredAudienceModel$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAudienceModel$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAudienceGenerationJob$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createTrainingDataset$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createConfiguredAudienceModel$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createAudienceModel$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

