/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.checksums.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.SdkChecksum;
import software.amazon.awssdk.checksums.internal.DigestAlgorithm;

@SdkInternalApi
public class DigestAlgorithmChecksum
implements SdkChecksum {
    private final DigestAlgorithm algorithm;
    private DigestAlgorithm.CloseableMessageDigest digest;
    private DigestAlgorithm.CloseableMessageDigest digestLastMarked;

    public DigestAlgorithmChecksum(DigestAlgorithm algorithm) {
        this.algorithm = algorithm;
        this.digest = this.newDigest();
    }

    private DigestAlgorithm.CloseableMessageDigest newDigest() {
        return this.algorithm.getDigest();
    }

    @Override
    public void update(int b) {
        this.digest.messageDigest().update((byte)b);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.digest.messageDigest().update(b, off, len);
    }

    @Override
    public long getValue() {
        throw new UnsupportedOperationException("Use getChecksumBytes() instead.");
    }

    @Override
    public void reset() {
        this.digest.close();
        this.digest = this.digestLastMarked == null ? this.newDigest() : this.digestLastMarked;
    }

    @Override
    public byte[] getChecksumBytes() {
        return this.digest.digest();
    }

    @Override
    public void mark(int readLimit) {
        this.digestLastMarked = this.digest.clone();
    }
}

