/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.applicationdiscovery.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ExportDataFormat {
    CSV("CSV"),
    GRAPHML("GRAPHML"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ExportDataFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ExportDataFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ExportDataFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ExportDataFormat> knownValues() {
        return Stream.of(ExportDataFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

