/*
 * Decompiled with CFR 0.152.
 */
package ru.ivi.opensource.flinkclickhousesink.model;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ClickHouseClusterSettings {
    public static final String CLICKHOUSE_HOSTS = "clickhouse.access.hosts";
    public static final String CLICKHOUSE_USER = "clickhouse.access.user";
    public static final String CLICKHOUSE_PASSWORD = "clickhouse.access.password";
    private final List<String> hostsWithPorts;
    private final String user;
    private final String password;
    private final String credentials;
    private final boolean authorizationRequired;
    private int currentHostId = 0;

    public ClickHouseClusterSettings(Map<String, String> parameters) {
        Preconditions.checkNotNull(parameters);
        String hostsString = parameters.get(CLICKHOUSE_HOSTS);
        Preconditions.checkNotNull((Object)hostsString);
        this.hostsWithPorts = ClickHouseClusterSettings.buildHostsAndPort(hostsString);
        Preconditions.checkArgument((this.hostsWithPorts.size() > 0 ? 1 : 0) != 0);
        String usr = parameters.get(CLICKHOUSE_USER);
        String pass = parameters.get(CLICKHOUSE_PASSWORD);
        if (StringUtils.isNotEmpty((CharSequence)usr) && StringUtils.isNotEmpty((CharSequence)pass)) {
            this.user = parameters.get(CLICKHOUSE_USER);
            this.password = parameters.get(CLICKHOUSE_PASSWORD);
            this.credentials = ClickHouseClusterSettings.buildCredentials(this.user, this.password);
            this.authorizationRequired = true;
        } else {
            this.credentials = "";
            this.password = "";
            this.user = "";
            this.authorizationRequired = false;
        }
    }

    private static List<String> buildHostsAndPort(String hostsString) {
        return Arrays.stream(hostsString.split(", ")).map(ClickHouseClusterSettings::checkHttpAndAdd).collect(Collectors.toList());
    }

    private static String checkHttpAndAdd(String host) {
        String newHost = host.replace(" ", "");
        if (!newHost.contains("http")) {
            return "http://" + newHost;
        }
        return newHost;
    }

    private static String buildCredentials(String user, String password) {
        Base64.Encoder x = Base64.getEncoder();
        String credentials = String.join((CharSequence)":", user, password);
        return new String(x.encode(credentials.getBytes()));
    }

    public String getRandomHostUrl() {
        this.currentHostId = ThreadLocalRandom.current().nextInt(this.hostsWithPorts.size());
        return this.hostsWithPorts.get(this.currentHostId);
    }

    public String getNextHost() {
        this.currentHostId = this.currentHostId >= this.hostsWithPorts.size() - 1 ? 0 : ++this.currentHostId;
        return this.hostsWithPorts.get(this.currentHostId);
    }

    public List<String> getHostsWithPorts() {
        return this.hostsWithPorts;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public boolean isAuthorizationRequired() {
        return this.authorizationRequired;
    }

    public String toString() {
        return "ClickHouseClusterSettings{hostsWithPorts=" + this.hostsWithPorts + ", credentials='" + this.credentials + '\'' + ", authorizationRequired=" + this.authorizationRequired + ", currentHostId=" + this.currentHostId + '}';
    }
}

