/*
 * Decompiled with CFR 0.152.
 */
package ru.ivi.opensource.flinkclickhousesink.applied;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ivi.opensource.flinkclickhousesink.applied.ClickHouseSinkBuffer;
import ru.ivi.opensource.flinkclickhousesink.applied.ClickHouseSinkScheduledCheckerAndCleaner;
import ru.ivi.opensource.flinkclickhousesink.applied.ClickHouseWriter;
import ru.ivi.opensource.flinkclickhousesink.applied.ExceptionsThrowableSink;
import ru.ivi.opensource.flinkclickhousesink.applied.Sink;
import ru.ivi.opensource.flinkclickhousesink.applied.UnexceptionableSink;
import ru.ivi.opensource.flinkclickhousesink.model.ClickHouseSinkCommonParams;

public class ClickHouseSinkManager
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ClickHouseSinkManager.class);
    private final ClickHouseWriter clickHouseWriter;
    private final ClickHouseSinkScheduledCheckerAndCleaner clickHouseSinkScheduledCheckerAndCleaner;
    private final ClickHouseSinkCommonParams sinkParams;
    private final List<CompletableFuture<Boolean>> futures = Collections.synchronizedList(new LinkedList());
    private volatile boolean isClosed = false;

    public ClickHouseSinkManager(Map<String, String> globalParams) {
        this.sinkParams = new ClickHouseSinkCommonParams(globalParams);
        this.clickHouseWriter = new ClickHouseWriter(this.sinkParams, this.futures);
        this.clickHouseSinkScheduledCheckerAndCleaner = new ClickHouseSinkScheduledCheckerAndCleaner(this.sinkParams, this.futures);
        logger.info("Build sink writer's manager. params = {}", (Object)this.sinkParams.toString());
    }

    public Sink buildSink(Properties localProperties) {
        String targetTable = localProperties.getProperty("clickhouse.sink.target-table");
        int maxFlushBufferSize = Integer.parseInt(localProperties.getProperty("clickhouse.sink.max-buffer-size"));
        return this.buildSink(targetTable, maxFlushBufferSize);
    }

    public Sink buildSink(String targetTable, int maxBufferSize) {
        Preconditions.checkNotNull((Object)this.clickHouseSinkScheduledCheckerAndCleaner);
        Preconditions.checkNotNull((Object)this.clickHouseWriter);
        ClickHouseSinkBuffer clickHouseSinkBuffer = ClickHouseSinkBuffer.Builder.aClickHouseSinkBuffer().withTargetTable(targetTable).withMaxFlushBufferSize(maxBufferSize).withTimeoutSec(this.sinkParams.getTimeout()).withFutures(this.futures).build(this.clickHouseWriter);
        this.clickHouseSinkScheduledCheckerAndCleaner.addSinkBuffer(clickHouseSinkBuffer);
        if (this.sinkParams.isIgnoringClickHouseSendingExceptionEnabled()) {
            return new UnexceptionableSink(clickHouseSinkBuffer);
        }
        return new ExceptionsThrowableSink(clickHouseSinkBuffer);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void close() throws Exception {
        logger.info("ClickHouse sink manager is shutting down.");
        this.clickHouseSinkScheduledCheckerAndCleaner.close();
        this.clickHouseWriter.close();
        this.isClosed = true;
        logger.info("ClickHouse sink manager shutdown complete.");
    }
}

