/*
 * Decompiled with CFR 0.152.
 */
package ru.ivi.opensource.flinkclickhousesink.model;

import com.google.common.base.Preconditions;
import java.util.Map;
import ru.ivi.opensource.flinkclickhousesink.model.ClickhouseClusterSettings;

public class ClickhouseSinkCommonParams {
    private final ClickhouseClusterSettings clickhouseClusterSettings;
    private final String failedRecordsPath;
    private final int numWriters;
    private final int queueMaxCapacity;
    private final int timeout;
    private final int maxRetries;

    public ClickhouseSinkCommonParams(Map<String, String> params) {
        this.clickhouseClusterSettings = new ClickhouseClusterSettings(params);
        this.numWriters = Integer.valueOf(params.get("clickhouse.sink.num-writers"));
        this.queueMaxCapacity = Integer.valueOf(params.get("clickhouse.sink.queue-max-capacity"));
        this.maxRetries = Integer.valueOf(params.get("clickhouse.sink.retries"));
        this.timeout = Integer.valueOf(params.get("clickhouse.sink.timeout-sec"));
        this.failedRecordsPath = params.get("clickhouse.sink.failed-records-path");
        Preconditions.checkNotNull((Object)this.failedRecordsPath);
        Preconditions.checkArgument((this.queueMaxCapacity > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.numWriters > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.timeout > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((this.maxRetries > 0 ? 1 : 0) != 0);
    }

    public int getNumWriters() {
        return this.numWriters;
    }

    public int getQueueMaxCapacity() {
        return this.queueMaxCapacity;
    }

    public ClickhouseClusterSettings getClickhouseClusterSettings() {
        return this.clickhouseClusterSettings;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public String getFailedRecordsPath() {
        return this.failedRecordsPath;
    }

    public String toString() {
        return "ClickhouseSinkCommonParams{clickhouseClusterSettings=" + this.clickhouseClusterSettings + ", failedRecordsPath='" + this.failedRecordsPath + '\'' + ", numWriters=" + this.numWriters + ", queueMaxCapacity=" + this.queueMaxCapacity + ", timeout=" + this.timeout + ", maxRetries=" + this.maxRetries + '}';
    }
}

