/*
 * Decompiled with CFR 0.152.
 */
package ru.ivi.opensource.flinkclickhousesink.applied;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ivi.opensource.flinkclickhousesink.applied.ClickhouseSinkBuffer;
import ru.ivi.opensource.flinkclickhousesink.applied.ClickhouseSinkScheduledChecker;
import ru.ivi.opensource.flinkclickhousesink.applied.ClickhouseWriter;
import ru.ivi.opensource.flinkclickhousesink.model.ClickhouseSinkCommonParams;

public class ClickhouseSinkManager
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ClickhouseSinkManager.class);
    private final ClickhouseWriter clickhouseWriter;
    private final ClickhouseSinkScheduledChecker clickhouseSinkScheduledChecker;
    private final ClickhouseSinkCommonParams sinkParams;
    private volatile boolean isClosed = false;

    public ClickhouseSinkManager(Map<String, String> globalParams) {
        this.sinkParams = new ClickhouseSinkCommonParams(globalParams);
        this.clickhouseWriter = new ClickhouseWriter(this.sinkParams);
        this.clickhouseSinkScheduledChecker = new ClickhouseSinkScheduledChecker(this.sinkParams);
        logger.info("Build sink writer's manager. params = {}", (Object)this.sinkParams.toString());
    }

    public ClickhouseSinkBuffer buildBuffer(Properties localProperties) {
        String targetTable = localProperties.getProperty("clickhouse.sink.target-table");
        int maxFlushBufferSize = Integer.valueOf(localProperties.getProperty("clickhouse.sink.max-buffer-size"));
        return this.buildBuffer(targetTable, maxFlushBufferSize);
    }

    public ClickhouseSinkBuffer buildBuffer(String targetTable, int maxBufferSize) {
        Preconditions.checkNotNull((Object)this.clickhouseSinkScheduledChecker);
        Preconditions.checkNotNull((Object)this.clickhouseWriter);
        ClickhouseSinkBuffer clickhouseSinkBuffer = ClickhouseSinkBuffer.Builder.aClickhouseSinkBuffer().withTargetTable(targetTable).withMaxFlushBufferSize(maxBufferSize).withTimeoutSec(this.sinkParams.getTimeout()).build(this.clickhouseWriter);
        this.clickhouseSinkScheduledChecker.addSinkBuffer(clickhouseSinkBuffer);
        return clickhouseSinkBuffer;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void close() throws Exception {
        this.clickhouseWriter.close();
        this.clickhouseSinkScheduledChecker.close();
        this.isClosed = true;
    }
}

