/*
 * Decompiled with CFR 0.152.
 */
package ru.ivi.opensource.flinkclickhousesink.applied;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.ivi.opensource.flinkclickhousesink.applied.ClickhouseWriter;
import ru.ivi.opensource.flinkclickhousesink.model.ClickhouseRequestBlank;

public class ClickhouseSinkBuffer
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(ClickhouseSinkBuffer.class);
    private final ClickhouseWriter writer;
    private final String targetTable;
    private final int maxFlushBufferSize;
    private final long timeoutMillis;
    private final List<String> localValues;
    private volatile long lastAddTimeMillis = 0L;

    private ClickhouseSinkBuffer(ClickhouseWriter chWriter, long timeout, int maxBuffer, String table) {
        this.writer = chWriter;
        this.localValues = new ArrayList<String>();
        this.timeoutMillis = timeout;
        this.maxFlushBufferSize = maxBuffer;
        this.targetTable = table;
        logger.info("Instance Clickhouse Sink, target table = {}, buffer size = {}", (Object)this.targetTable, (Object)this.maxFlushBufferSize);
    }

    String getTargetTable() {
        return this.targetTable;
    }

    public void put(String recordAsCSV) {
        this.tryAddToQueue();
        this.localValues.add(recordAsCSV);
        this.lastAddTimeMillis = System.currentTimeMillis();
    }

    synchronized void tryAddToQueue() {
        if (this.flushCondition()) {
            this.addToQueue();
        }
    }

    private void addToQueue() {
        List<String> deepCopy = ClickhouseSinkBuffer.buildDeepCopy(this.localValues);
        ClickhouseRequestBlank params = ClickhouseRequestBlank.Builder.aBuilder().withValues(deepCopy).withTargetTable(this.targetTable).build();
        logger.debug("Build blank with params: buffer size = {}, target table  = {}", (Object)params.getValues().size(), (Object)params.getTargetTable());
        this.writer.put(params);
        this.localValues.clear();
    }

    private boolean flushCondition() {
        return this.localValues.size() > 0 && (this.checkSize() || this.checkTime());
    }

    private boolean checkSize() {
        return this.localValues.size() >= this.maxFlushBufferSize;
    }

    private boolean checkTime() {
        if (this.lastAddTimeMillis == 0L) {
            return false;
        }
        long current = System.currentTimeMillis();
        return current - this.lastAddTimeMillis > this.timeoutMillis;
    }

    private static List<String> buildDeepCopy(List<String> original) {
        return Collections.unmodifiableList(new ArrayList<String>(original));
    }

    @Override
    public void close() {
        if (this.localValues != null && this.localValues.size() > 0) {
            this.addToQueue();
        }
    }

    public static final class Builder {
        private String targetTable;
        private int maxFlushBufferSize;
        private int timeoutSec;

        private Builder() {
        }

        public static Builder aClickhouseSinkBuffer() {
            return new Builder();
        }

        public Builder withTargetTable(String targetTable) {
            this.targetTable = targetTable;
            return this;
        }

        public Builder withMaxFlushBufferSize(int maxFlushBufferSize) {
            this.maxFlushBufferSize = maxFlushBufferSize;
            return this;
        }

        public Builder withTimeoutSec(int timeoutSec) {
            this.timeoutSec = timeoutSec;
            return this;
        }

        public ClickhouseSinkBuffer build(ClickhouseWriter writer) {
            Preconditions.checkNotNull((Object)this.targetTable);
            Preconditions.checkArgument((this.maxFlushBufferSize > 0 ? 1 : 0) != 0);
            Preconditions.checkArgument((this.timeoutSec > 0 ? 1 : 0) != 0);
            return new ClickhouseSinkBuffer(writer, TimeUnit.SECONDS.toMillis(this.timeoutSec), this.maxFlushBufferSize, this.targetTable);
        }
    }
}

